/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.expression;

import io.druid.java.util.common.IAE;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.SqlOperatorConversion;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;

public class AliasedOperatorConversion
implements SqlOperatorConversion {
    private final SqlOperatorConversion baseConversion;
    private final String name;
    private final SqlOperator operator;

    public AliasedOperatorConversion(SqlOperatorConversion baseConversion, String name) {
        if (!SqlKind.FUNCTION.contains(baseConversion.calciteOperator().getKind())) {
            throw new IAE("Base operator must be a function but was[%s]", new Object[]{baseConversion.calciteOperator().getKind()});
        }
        SqlFunction baseFunction = (SqlFunction)baseConversion.calciteOperator();
        this.baseConversion = baseConversion;
        this.name = name;
        this.operator = new SqlFunction(name, baseFunction.getKind(), baseFunction.getReturnTypeInference(), baseFunction.getOperandTypeInference(), baseFunction.getOperandTypeChecker(), baseFunction.getFunctionType());
    }

    @Override
    public SqlOperator calciteOperator() {
        return this.operator;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return this.baseConversion.toDruidExpression(plannerContext, rowSignature, rexNode);
    }
}

