/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.expression;

import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.OperatorConversions;
import io.druid.sql.calcite.expression.SqlOperatorConversion;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;

public class DirectOperatorConversion
implements SqlOperatorConversion {
    private final SqlOperator operator;
    private final String druidFunctionName;

    public DirectOperatorConversion(SqlOperator operator, String druidFunctionName) {
        this.operator = operator;
        this.druidFunctionName = druidFunctionName;
    }

    @Override
    public SqlOperator calciteOperator() {
        return this.operator;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, operands -> DruidExpression.fromExpression(DruidExpression.functionCall(this.druidFunctionName, operands)));
    }
}

