/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.expression;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Chars;
import io.druid.java.util.common.StringUtils;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprMacroTable;
import io.druid.math.expr.Parser;
import io.druid.segment.column.ValueType;
import io.druid.segment.virtual.ExpressionVirtualColumn;
import io.druid.sql.calcite.expression.SimpleExtraction;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class DruidExpression {
    private static final char[] SAFE_CHARS = " ,._-;:(){}[]<>!@#$%^&*`~?/".toCharArray();
    private final SimpleExtraction simpleExtraction;
    private final String expression;

    private DruidExpression(SimpleExtraction simpleExtraction, String expression) {
        this.simpleExtraction = simpleExtraction;
        this.expression = (String)Preconditions.checkNotNull((Object)expression);
    }

    public static DruidExpression of(SimpleExtraction simpleExtraction, String expression) {
        return new DruidExpression(simpleExtraction, expression);
    }

    public static DruidExpression fromColumn(String column) {
        return new DruidExpression(SimpleExtraction.of(column, null), StringUtils.format((String)"\"%s\"", (Object[])new Object[]{DruidExpression.escape(column)}));
    }

    public static DruidExpression fromExpression(String expression) {
        return new DruidExpression(null, expression);
    }

    public static DruidExpression fromFunctionCall(String functionName, List<DruidExpression> args) {
        return new DruidExpression(null, DruidExpression.functionCall(functionName, args));
    }

    public static String numberLiteral(Number n) {
        return n == null ? DruidExpression.nullLiteral() : n.toString();
    }

    public static String stringLiteral(String s) {
        return s == null ? DruidExpression.nullLiteral() : "'" + DruidExpression.escape(s) + "'";
    }

    public static String nullLiteral() {
        return "''";
    }

    public static String functionCall(String functionName, List<DruidExpression> args) {
        Preconditions.checkNotNull((Object)functionName, (Object)"functionName");
        Preconditions.checkNotNull(args, (Object)"args");
        StringBuilder builder = new StringBuilder(functionName);
        builder.append("(");
        for (int i = 0; i < args.size(); ++i) {
            DruidExpression arg = (DruidExpression)Preconditions.checkNotNull((Object)args.get(i), (String)"arg #%s", (Object[])new Object[]{i});
            builder.append(arg.getExpression());
            if (i >= args.size() - 1) continue;
            builder.append(",");
        }
        builder.append(")");
        return builder.toString();
    }

    public static String functionCall(String functionName, DruidExpression ... args) {
        return DruidExpression.functionCall(functionName, Arrays.asList(args));
    }

    private static String escape(String s) {
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || Arrays.binarySearch(SAFE_CHARS, c) >= 0) {
                escaped.append(c);
                continue;
            }
            escaped.append("\\u").append(BaseEncoding.base16().encode(Chars.toByteArray((char)c)));
        }
        return escaped.toString();
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isDirectColumnAccess() {
        return this.simpleExtraction != null && this.simpleExtraction.getExtractionFn() == null;
    }

    public String getDirectColumn() {
        return (String)Preconditions.checkNotNull((Object)this.simpleExtraction.getColumn());
    }

    public boolean isSimpleExtraction() {
        return this.simpleExtraction != null;
    }

    public Expr parse(ExprMacroTable macroTable) {
        return Parser.parse((String)this.expression, (ExprMacroTable)macroTable);
    }

    public SimpleExtraction getSimpleExtraction() {
        return (SimpleExtraction)Preconditions.checkNotNull((Object)this.simpleExtraction);
    }

    public ExpressionVirtualColumn toVirtualColumn(String name, ValueType outputType, ExprMacroTable macroTable) {
        return new ExpressionVirtualColumn(name, this.expression, outputType, macroTable);
    }

    public DruidExpression map(Function<SimpleExtraction, SimpleExtraction> extractionMap, Function<String, String> expressionMap) {
        return new DruidExpression(this.simpleExtraction == null ? null : extractionMap.apply(this.simpleExtraction), expressionMap.apply(this.expression));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidExpression that = (DruidExpression)o;
        return Objects.equals(this.simpleExtraction, that.simpleExtraction) && Objects.equals(this.expression, that.expression);
    }

    public int hashCode() {
        return Objects.hash(this.simpleExtraction, this.expression);
    }

    public String toString() {
        return "DruidExpression{simpleExtraction=" + this.simpleExtraction + ", expression='" + this.expression + '\'' + '}';
    }

    static {
        Arrays.sort(SAFE_CHARS);
    }
}

