/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.expression;

import com.google.common.collect.Lists;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.query.extraction.CascadeExtractionFn;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.TimeFormatExtractionFn;
import java.util.ArrayList;
import java.util.Arrays;

public class ExtractionFns {
    public static Granularity toQueryGranularity(ExtractionFn extractionFn) {
        TimeFormatExtractionFn fn;
        if (extractionFn instanceof TimeFormatExtractionFn && (fn = (TimeFormatExtractionFn)extractionFn).getFormat() == null && fn.getTimeZone() == null && fn.getLocale() == null && fn.isAsMillis()) {
            return fn.getGranularity();
        }
        return null;
    }

    public static ExtractionFn fromQueryGranularity(Granularity queryGranularity) {
        if (queryGranularity == null) {
            return null;
        }
        return new TimeFormatExtractionFn(null, null, null, queryGranularity, true);
    }

    public static ExtractionFn cascade(ExtractionFn f, ExtractionFn g) {
        if (f == null) {
            return g;
        }
        if (g == null) {
            return f;
        }
        ArrayList extractionFns = Lists.newArrayList();
        if (f instanceof CascadeExtractionFn) {
            extractionFns.addAll(Arrays.asList(((CascadeExtractionFn)f).getExtractionFns()));
        } else {
            extractionFns.add(f);
        }
        if (g instanceof CascadeExtractionFn) {
            extractionFns.addAll(Arrays.asList(((CascadeExtractionFn)g).getExtractionFns()));
        } else {
            extractionFns.add(g);
        }
        return new CascadeExtractionFn(extractionFns.toArray(new ExtractionFn[extractionFns.size()]));
    }
}

