/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.expression;

import com.google.common.collect.Iterables;
import io.druid.java.util.common.StringUtils;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.OperatorConversions;
import io.druid.sql.calcite.expression.SqlOperatorConversion;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;

public class UnaryPrefixOperatorConversion
implements SqlOperatorConversion {
    private final SqlOperator operator;
    private final String druidOperator;

    public UnaryPrefixOperatorConversion(SqlOperator operator, String druidOperator) {
        this.operator = operator;
        this.druidOperator = druidOperator;
    }

    @Override
    public SqlOperator calciteOperator() {
        return this.operator;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, operands -> DruidExpression.fromExpression(StringUtils.format((String)"(%s %s)", (Object[])new Object[]{this.druidOperator, ((DruidExpression)Iterables.getOnlyElement((Iterable)operands)).getExpression()})));
    }
}

