/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.expression.builtin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.StringUtils;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprMacroTable;
import io.druid.math.expr.Parser;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.OperatorConversions;
import io.druid.sql.calcite.expression.SqlOperatorConversion;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.joda.time.Period;

public class DateTruncOperatorConversion
implements SqlOperatorConversion {
    private static final Map<String, Period> TRUNC_PERIOD_MAP = ImmutableMap.builder().put((Object)"microseconds", (Object)Period.millis((int)1)).put((Object)"milliseconds", (Object)Period.millis((int)1)).put((Object)"second", (Object)Period.seconds((int)1)).put((Object)"minute", (Object)Period.minutes((int)1)).put((Object)"hour", (Object)Period.hours((int)1)).put((Object)"day", (Object)Period.days((int)1)).put((Object)"week", (Object)Period.weeks((int)1)).put((Object)"month", (Object)Period.months((int)1)).put((Object)"quarter", (Object)Period.months((int)3)).put((Object)"year", (Object)Period.years((int)1)).put((Object)"decade", (Object)Period.years((int)10)).put((Object)"century", (Object)Period.years((int)100)).put((Object)"millennium", (Object)Period.years((int)1000)).build();
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("DATE_TRUNC").operandTypes(SqlTypeFamily.CHARACTER, SqlTypeFamily.TIMESTAMP).requiredOperands(2).returnType(SqlTypeName.TIMESTAMP).functionCategory(SqlFunctionCategory.TIMEDATE).build();

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, inputExpressions -> {
            DruidExpression arg = (DruidExpression)inputExpressions.get(1);
            Expr truncTypeExpr = Parser.parse((String)((DruidExpression)inputExpressions.get(0)).getExpression(), (ExprMacroTable)plannerContext.getExprMacroTable());
            if (!truncTypeExpr.isLiteral()) {
                throw new IAE("Operator[%s] truncType must be a literal", new Object[]{this.calciteOperator().getName()});
            }
            String truncType = (String)truncTypeExpr.getLiteralValue();
            Period truncPeriod = TRUNC_PERIOD_MAP.get(StringUtils.toLowerCase((String)truncType));
            if (truncPeriod == null) {
                throw new IAE("Operator[%s] cannot truncate to[%s]", new Object[]{this.calciteOperator().getName(), truncType});
            }
            return DruidExpression.fromFunctionCall("timestamp_floor", (List<DruidExpression>)ImmutableList.of((Object)arg, (Object)DruidExpression.fromExpression(DruidExpression.stringLiteral(truncPeriod.toString())), (Object)DruidExpression.fromExpression(DruidExpression.stringLiteral(null)), (Object)DruidExpression.fromExpression(DruidExpression.stringLiteral(plannerContext.getTimeZone().getID()))));
        });
    }
}

