/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.expression.builtin;

import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.granularity.PeriodGranularity;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.Expressions;
import io.druid.sql.calcite.expression.SqlOperatorConversion;
import io.druid.sql.calcite.expression.TimeUnits;
import io.druid.sql.calcite.expression.builtin.TimeFloorOperatorConversion;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class FloorOperatorConversion
implements SqlOperatorConversion {
    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.FLOOR;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        RexNode arg = (RexNode)call.getOperands().get(0);
        DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, arg);
        if (druidExpression == null) {
            return null;
        }
        if (call.getOperands().size() == 1) {
            return druidExpression.map(simpleExtraction -> null, expression -> StringUtils.format((String)"floor(%s)", (Object[])new Object[]{expression}));
        }
        if (call.getOperands().size() == 2) {
            RexLiteral flag = (RexLiteral)call.getOperands().get(1);
            TimeUnitRange timeUnit = (TimeUnitRange)flag.getValue();
            PeriodGranularity granularity = TimeUnits.toQueryGranularity(timeUnit, plannerContext.getTimeZone());
            if (granularity == null) {
                return null;
            }
            return TimeFloorOperatorConversion.applyTimestampFloor(druidExpression, granularity, plannerContext.getExprMacroTable());
        }
        return null;
    }
}

