/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.expression.builtin;

import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.OperatorConversions;
import io.druid.sql.calcite.expression.SqlOperatorConversion;
import io.druid.sql.calcite.expression.builtin.TrimOperatorConversion;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;

public class LTrimOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("LTRIM").operandTypes(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER).returnType(SqlTypeName.VARCHAR).functionCategory(SqlFunctionCategory.STRING).requiredOperands(1).build();

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> {
            if (druidExpressions.size() > 1) {
                return TrimOperatorConversion.makeTrimExpression(SqlTrimFunction.Flag.LEADING, (DruidExpression)druidExpressions.get(0), (DruidExpression)druidExpressions.get(1));
            }
            return TrimOperatorConversion.makeTrimExpression(SqlTrimFunction.Flag.LEADING, (DruidExpression)druidExpressions.get(0), DruidExpression.fromExpression(DruidExpression.stringLiteral(" ")));
        });
    }
}

