/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.expression.builtin;

import io.druid.java.util.common.StringUtils;
import io.druid.math.expr.Expr;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.RegexDimExtractionFn;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.OperatorConversions;
import io.druid.sql.calcite.expression.SqlOperatorConversion;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;

public class RegexpExtractOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("REGEXP_EXTRACT").operandTypes(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER).requiredOperands(2).returnType(SqlTypeName.VARCHAR).functionCategory(SqlFunctionCategory.STRING).build();
    private static final int DEFAULT_INDEX = 0;

    public SqlFunction calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, StringUtils.toLowerCase((String)this.calciteOperator().getName()), inputExpressions -> {
            Expr indexExpr;
            DruidExpression arg = (DruidExpression)inputExpressions.get(0);
            Expr patternExpr = ((DruidExpression)inputExpressions.get(1)).parse(plannerContext.getExprMacroTable());
            Expr expr = indexExpr = inputExpressions.size() > 2 ? ((DruidExpression)inputExpressions.get(2)).parse(plannerContext.getExprMacroTable()) : null;
            if (arg.isSimpleExtraction() && patternExpr.isLiteral() && (indexExpr == null || indexExpr.isLiteral())) {
                return arg.getSimpleExtraction().cascade((ExtractionFn)new RegexDimExtractionFn((String)patternExpr.getLiteralValue(), Integer.valueOf(indexExpr == null ? 0 : ((Number)indexExpr.getLiteralValue()).intValue()), Boolean.valueOf(true), null));
            }
            return null;
        });
    }
}

