/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.expression.builtin;

import io.druid.java.util.common.StringUtils;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.SubstringDimExtractionFn;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.Expressions;
import io.druid.sql.calcite.expression.OperatorConversions;
import io.druid.sql.calcite.expression.SqlOperatorConversion;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeFamily;

public class SubstringOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("SUBSTRING").operandTypes(SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER).functionCategory(SqlFunctionCategory.STRING).returnTypeInference(ReturnTypes.ARG0).requiredOperands(2).build();

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        DruidExpression input = Expressions.toDruidExpression(plannerContext, rowSignature, (RexNode)call.getOperands().get(0));
        if (input == null) {
            return null;
        }
        int index = RexLiteral.intValue((RexNode)((RexNode)call.getOperands().get(1))) - 1;
        int length = call.getOperands().size() > 2 ? RexLiteral.intValue((RexNode)((RexNode)call.getOperands().get(2))) : -1;
        return input.map(simpleExtraction -> simpleExtraction.cascade((ExtractionFn)new SubstringDimExtractionFn(index, length < 0 ? null : Integer.valueOf(length))), expression -> StringUtils.format((String)"substring(%s, %s, %s)", (Object[])new Object[]{expression, DruidExpression.numberLiteral(index), DruidExpression.numberLiteral(length)}));
    }
}

