/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.expression.builtin;

import com.google.common.base.Preconditions;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.StringUtils;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.Expressions;
import io.druid.sql.calcite.expression.SqlOperatorConversion;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import java.util.List;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeFamily;

public abstract class TimeArithmeticOperatorConversion
implements SqlOperatorConversion {
    private final SqlOperator operator;
    private final int direction;

    public TimeArithmeticOperatorConversion(SqlOperator operator, int direction) {
        this.operator = operator;
        this.direction = direction;
        Preconditions.checkArgument((direction > 0 || direction < 0 ? 1 : 0) != 0);
    }

    @Override
    public SqlOperator calciteOperator() {
        return this.operator;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        List operands = call.getOperands();
        if (operands.size() != 2) {
            throw new IAE("Expected 2 args, got %s", new Object[]{operands.size()});
        }
        RexNode timeRexNode = (RexNode)operands.get(0);
        RexNode shiftRexNode = (RexNode)operands.get(1);
        DruidExpression timeExpr = Expressions.toDruidExpression(plannerContext, rowSignature, timeRexNode);
        DruidExpression shiftExpr = Expressions.toDruidExpression(plannerContext, rowSignature, shiftRexNode);
        if (timeExpr == null || shiftExpr == null) {
            return null;
        }
        if (shiftRexNode.getType().getFamily() == SqlTypeFamily.INTERVAL_YEAR_MONTH) {
            return DruidExpression.fromExpression(DruidExpression.functionCall("timestamp_shift", timeExpr, shiftExpr.map(simpleExtraction -> null, expression -> StringUtils.format((String)"concat('P', %s, 'M')", (Object[])new Object[]{expression})), DruidExpression.fromExpression(DruidExpression.numberLiteral(this.direction > 0 ? 1 : -1))));
        }
        if (shiftRexNode.getType().getFamily() == SqlTypeFamily.INTERVAL_DAY_TIME) {
            return DruidExpression.fromExpression(StringUtils.format((String)"(%s %s %s)", (Object[])new Object[]{timeExpr.getExpression(), this.direction > 0 ? "+" : "-", shiftExpr.getExpression()}));
        }
        throw new ISE("Got unexpected type period type family[%s]", new Object[]{shiftRexNode.getType().getFamily()});
    }

    public static class TimeMinusIntervalOperatorConversion
    extends TimeArithmeticOperatorConversion {
        public TimeMinusIntervalOperatorConversion() {
            super((SqlOperator)SqlStdOperatorTable.MINUS_DATE, -1);
        }
    }

    public static class TimePlusIntervalOperatorConversion
    extends TimeArithmeticOperatorConversion {
        public TimePlusIntervalOperatorConversion() {
            super((SqlOperator)SqlStdOperatorTable.DATETIME_PLUS, 1);
        }
    }
}

