/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.expression.builtin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.druid.java.util.common.granularity.PeriodGranularity;
import io.druid.math.expr.ExprMacroTable;
import io.druid.query.expression.TimestampFloorExprMacro;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.Expressions;
import io.druid.sql.calcite.expression.OperatorConversions;
import io.druid.sql.calcite.expression.SqlOperatorConversion;
import io.druid.sql.calcite.planner.Calcites;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;

public class TimeFloorOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("TIME_FLOOR").operandTypes(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.CHARACTER, SqlTypeFamily.TIMESTAMP, SqlTypeFamily.CHARACTER).requiredOperands(2).returnType(SqlTypeName.TIMESTAMP).functionCategory(SqlFunctionCategory.TIMEDATE).build();

    public static DruidExpression applyTimestampFloor(DruidExpression input, PeriodGranularity granularity, ExprMacroTable macroTable) {
        PeriodGranularity inputGranularity;
        TimestampFloorExprMacro.TimestampFloorExpr floorExpr;
        Preconditions.checkNotNull((Object)input, (Object)"input");
        Preconditions.checkNotNull((Object)granularity, (Object)"granularity");
        if (granularity.getPeriod().equals((Object)Period.days((int)1)) && (floorExpr = Expressions.asTimestampFloorExpr(input, macroTable)) != null && Objects.equals((inputGranularity = floorExpr.getGranularity()).getTimeZone(), granularity.getTimeZone()) && Objects.equals(inputGranularity.getOrigin(), granularity.getOrigin()) && TimeFloorOperatorConversion.periodIsDayMultiple(inputGranularity.getPeriod())) {
            return input;
        }
        return DruidExpression.fromFunctionCall("timestamp_floor", ImmutableList.of((Object)input.getExpression(), (Object)DruidExpression.stringLiteral(granularity.getPeriod().toString()), (Object)DruidExpression.numberLiteral(granularity.getOrigin() == null ? null : Long.valueOf(granularity.getOrigin().getMillis())), (Object)DruidExpression.stringLiteral(granularity.getTimeZone().toString())).stream().map(DruidExpression::fromExpression).collect(Collectors.toList()));
    }

    private static boolean periodIsDayMultiple(Period period) {
        return period.getMillis() == 0 && period.getSeconds() == 0 && period.getMinutes() == 0 && period.getHours() == 0 && (period.getDays() > 0 || period.getWeeks() > 0 || period.getMonths() > 0 || period.getYears() > 0);
    }

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        List operands = call.getOperands();
        List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, operands);
        if (druidExpressions == null) {
            return null;
        }
        if (((RexNode)operands.get(1)).isA(SqlKind.LITERAL) && (operands.size() <= 2 || ((RexNode)operands.get(2)).isA(SqlKind.LITERAL)) && (operands.size() <= 3 || ((RexNode)operands.get(3)).isA(SqlKind.LITERAL))) {
            Period period = new Period((Object)RexLiteral.stringValue((RexNode)((RexNode)operands.get(1))));
            DateTime origin = operands.size() > 2 && !RexLiteral.isNullLiteral((RexNode)((RexNode)operands.get(2))) ? Calcites.calciteDateTimeLiteralToJoda((RexNode)operands.get(2), plannerContext.getTimeZone()) : null;
            DateTimeZone timeZone = operands.size() > 3 && !RexLiteral.isNullLiteral((RexNode)((RexNode)operands.get(3))) ? DateTimeZone.forID((String)RexLiteral.stringValue((RexNode)((RexNode)operands.get(3)))) : plannerContext.getTimeZone();
            PeriodGranularity granularity = new PeriodGranularity(period, origin, timeZone);
            return TimeFloorOperatorConversion.applyTimestampFloor(druidExpressions.get(0), granularity, plannerContext.getExprMacroTable());
        }
        return DruidExpression.fromFunctionCall("timestamp_floor", druidExpressions);
    }
}

