/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.expression.builtin;

import com.google.common.collect.ImmutableList;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.Expressions;
import io.druid.sql.calcite.expression.OperatorConversions;
import io.druid.sql.calcite.expression.SqlOperatorConversion;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import java.util.stream.Collectors;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.joda.time.DateTimeZone;

public class TimeFormatOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("TIME_FORMAT").operandTypes(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER).requiredOperands(1).returnType(SqlTypeName.VARCHAR).functionCategory(SqlFunctionCategory.TIMEDATE).build();

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        RexNode timeArg = (RexNode)call.getOperands().get(0);
        DruidExpression timeExpression = Expressions.toDruidExpression(plannerContext, rowSignature, timeArg);
        if (timeExpression == null) {
            return null;
        }
        String pattern = call.getOperands().size() > 1 && !RexLiteral.isNullLiteral((RexNode)((RexNode)call.getOperands().get(1))) ? RexLiteral.stringValue((RexNode)((RexNode)call.getOperands().get(1))) : "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
        DateTimeZone timeZone = call.getOperands().size() > 2 && !RexLiteral.isNullLiteral((RexNode)((RexNode)call.getOperands().get(2))) ? DateTimeZone.forID((String)RexLiteral.stringValue((RexNode)((RexNode)call.getOperands().get(2)))) : plannerContext.getTimeZone();
        return DruidExpression.fromFunctionCall("timestamp_format", ImmutableList.of((Object)timeExpression.getExpression(), (Object)DruidExpression.stringLiteral(pattern), (Object)DruidExpression.stringLiteral(timeZone.getID())).stream().map(DruidExpression::fromExpression).collect(Collectors.toList()));
    }
}

