/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.expression.builtin;

import com.google.common.collect.ImmutableList;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.Expressions;
import io.druid.sql.calcite.expression.SqlOperatorConversion;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;

public class TrimOperatorConversion
implements SqlOperatorConversion {
    @Nullable
    public static DruidExpression makeTrimExpression(SqlTrimFunction.Flag trimStyle, DruidExpression stringExpression, DruidExpression charsExpression) {
        String functionName;
        switch (trimStyle) {
            case LEADING: {
                functionName = "ltrim";
                break;
            }
            case TRAILING: {
                functionName = "rtrim";
                break;
            }
            case BOTH: {
                functionName = "trim";
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return DruidExpression.fromFunctionCall(functionName, (List<DruidExpression>)ImmutableList.of((Object)stringExpression, (Object)charsExpression));
    }

    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.TRIM;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        RexLiteral flag = (RexLiteral)call.getOperands().get(0);
        SqlTrimFunction.Flag trimStyle = (SqlTrimFunction.Flag)flag.getValue();
        DruidExpression charsExpression = Expressions.toDruidExpression(plannerContext, rowSignature, (RexNode)call.getOperands().get(1));
        DruidExpression stringExpression = Expressions.toDruidExpression(plannerContext, rowSignature, (RexNode)call.getOperands().get(2));
        if (charsExpression == null || stringExpression == null) {
            return null;
        }
        return TrimOperatorConversion.makeTrimExpression(trimStyle, stringExpression, charsExpression);
    }
}

