/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.expression.builtin;

import io.druid.java.util.common.StringUtils;
import io.druid.math.expr.Expr;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.OperatorConversions;
import io.druid.sql.calcite.expression.SqlOperatorConversion;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeFamily;

public class TruncateOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("TRUNCATE").operandTypes(SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER).requiredOperands(1).returnTypeInference(ReturnTypes.ARG0).functionCategory(SqlFunctionCategory.NUMERIC).build();

    public SqlFunction calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, inputExpressions -> {
            String factorString;
            Expr digitsExpr;
            DruidExpression arg = (DruidExpression)inputExpressions.get(0);
            Expr expr = digitsExpr = inputExpressions.size() > 1 ? ((DruidExpression)inputExpressions.get(1)).parse(plannerContext.getExprMacroTable()) : null;
            if (digitsExpr == null) {
                factorString = "1";
            } else if (digitsExpr.isLiteral()) {
                int digits = ((Number)digitsExpr.getLiteralValue()).intValue();
                double factor = Math.pow(10.0, digits);
                factorString = DruidExpression.numberLiteral(factor);
            } else {
                factorString = StringUtils.format((String)"pow(10,%s)", (Object[])new Object[]{inputExpressions.get(1)});
            }
            return DruidExpression.fromExpression(StringUtils.format((String)"(cast(cast(%s * %s,'long'),'double') / %s)", (Object[])new Object[]{arg.getExpression(), factorString, factorString}));
        });
    }
}

