/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.filtration;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.NotDimFilter;
import io.druid.query.filter.OrDimFilter;
import io.druid.sql.calcite.filtration.Filtration;
import java.util.ArrayList;
import java.util.List;

public abstract class BottomUpTransform
implements Function<Filtration, Filtration> {
    protected abstract DimFilter process(DimFilter var1);

    private DimFilter checkedProcess(DimFilter filter) {
        DimFilter retVal = this.process((DimFilter)Preconditions.checkNotNull((Object)filter, (Object)"filter"));
        return (DimFilter)Preconditions.checkNotNull((Object)retVal, (String)"process(filter) result in %s", (Object[])new Object[]{this.getClass().getSimpleName()});
    }

    public Filtration apply(Filtration filtration) {
        if (filtration.getDimFilter() != null) {
            Filtration retVal = Filtration.create(this.apply0(filtration.getDimFilter()), filtration.getIntervals());
            return filtration.equals(retVal) ? retVal : this.apply(retVal);
        }
        return filtration;
    }

    private DimFilter apply0(DimFilter filter) {
        if (filter instanceof AndDimFilter) {
            List oldFilters = ((AndDimFilter)filter).getFields();
            ArrayList newFilters = Lists.newArrayList();
            for (DimFilter oldFilter : oldFilters) {
                DimFilter newFilter = this.apply0(oldFilter);
                if (newFilter == null) continue;
                newFilters.add(newFilter);
            }
            if (!newFilters.equals(oldFilters)) {
                return this.checkedProcess((DimFilter)new AndDimFilter((List)newFilters));
            }
            return this.checkedProcess(filter);
        }
        if (filter instanceof OrDimFilter) {
            List oldFilters = ((OrDimFilter)filter).getFields();
            ArrayList newFilters = Lists.newArrayList();
            for (DimFilter oldFilter : oldFilters) {
                DimFilter newFilter = this.apply0(oldFilter);
                if (newFilter == null) continue;
                newFilters.add(newFilter);
            }
            if (!newFilters.equals(oldFilters)) {
                return this.checkedProcess((DimFilter)new OrDimFilter((List)newFilters));
            }
            return this.checkedProcess(filter);
        }
        if (filter instanceof NotDimFilter) {
            DimFilter newFilter;
            DimFilter oldFilter = ((NotDimFilter)filter).getField();
            if (!oldFilter.equals(newFilter = this.apply0(oldFilter))) {
                return this.checkedProcess((DimFilter)new NotDimFilter(newFilter));
            }
            return this.checkedProcess(filter);
        }
        return this.checkedProcess(filter);
    }
}

