/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.filtration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import io.druid.java.util.common.ISE;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.BoundDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.NotDimFilter;
import io.druid.query.filter.OrDimFilter;
import io.druid.sql.calcite.filtration.BottomUpTransform;
import io.druid.sql.calcite.filtration.BoundRefKey;
import io.druid.sql.calcite.filtration.BoundValue;
import io.druid.sql.calcite.filtration.Bounds;
import io.druid.sql.calcite.filtration.Filtration;
import io.druid.sql.calcite.filtration.RangeSets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CombineAndSimplifyBounds
extends BottomUpTransform {
    private static final CombineAndSimplifyBounds INSTANCE = new CombineAndSimplifyBounds();

    private CombineAndSimplifyBounds() {
    }

    public static CombineAndSimplifyBounds instance() {
        return INSTANCE;
    }

    @Override
    public DimFilter process(DimFilter filter) {
        if (filter instanceof AndDimFilter) {
            List<DimFilter> children = this.getAndFilterChildren((AndDimFilter)filter);
            DimFilter one = CombineAndSimplifyBounds.doSimplifyAnd(children);
            DimFilter two = CombineAndSimplifyBounds.negate(CombineAndSimplifyBounds.doSimplifyOr(CombineAndSimplifyBounds.negateAll(children)));
            return CombineAndSimplifyBounds.computeCost(one) <= CombineAndSimplifyBounds.computeCost(two) ? one : two;
        }
        if (filter instanceof OrDimFilter) {
            List<DimFilter> children = this.getOrFilterChildren((OrDimFilter)filter);
            DimFilter one = CombineAndSimplifyBounds.doSimplifyOr(children);
            DimFilter two = CombineAndSimplifyBounds.negate(CombineAndSimplifyBounds.doSimplifyAnd(CombineAndSimplifyBounds.negateAll(children)));
            return CombineAndSimplifyBounds.computeCost(one) <= CombineAndSimplifyBounds.computeCost(two) ? one : two;
        }
        if (filter instanceof NotDimFilter) {
            DimFilter field = ((NotDimFilter)filter).getField();
            DimFilter candidate = field instanceof OrDimFilter ? CombineAndSimplifyBounds.doSimplifyAnd(CombineAndSimplifyBounds.negateAll(this.getOrFilterChildren((OrDimFilter)field))) : (field instanceof AndDimFilter ? CombineAndSimplifyBounds.doSimplifyOr(CombineAndSimplifyBounds.negateAll(this.getAndFilterChildren((AndDimFilter)field))) : CombineAndSimplifyBounds.negate(field));
            return CombineAndSimplifyBounds.computeCost(filter) <= CombineAndSimplifyBounds.computeCost(candidate) ? filter : candidate;
        }
        return filter;
    }

    private List<DimFilter> getAndFilterChildren(AndDimFilter filter) {
        ArrayList<DimFilter> children = new ArrayList<DimFilter>();
        for (DimFilter field : filter.getFields()) {
            if (field instanceof AndDimFilter) {
                children.addAll(this.getAndFilterChildren((AndDimFilter)field));
                continue;
            }
            children.add(field);
        }
        return children;
    }

    private List<DimFilter> getOrFilterChildren(OrDimFilter filter) {
        ArrayList<DimFilter> children = new ArrayList<DimFilter>();
        for (DimFilter field : filter.getFields()) {
            if (field instanceof OrDimFilter) {
                children.addAll(this.getOrFilterChildren((OrDimFilter)field));
                continue;
            }
            children.add(field);
        }
        return children;
    }

    private static DimFilter doSimplifyAnd(List<DimFilter> children) {
        return CombineAndSimplifyBounds.doSimplify(children, false);
    }

    private static DimFilter doSimplifyOr(List<DimFilter> children) {
        return CombineAndSimplifyBounds.doSimplify(children, true);
    }

    private static DimFilter doSimplify(List<DimFilter> children, boolean disjunction) {
        List filterList;
        BoundRefKey boundRefKey;
        ArrayList newChildren = Lists.newArrayList(children);
        HashMap bounds = Maps.newHashMap();
        Iterator iterator = newChildren.iterator();
        while (iterator.hasNext()) {
            DimFilter child = (DimFilter)iterator.next();
            if (child.equals(Filtration.matchNothing())) {
                if (disjunction) {
                    iterator.remove();
                    continue;
                }
                return Filtration.matchNothing();
            }
            if (child.equals(Filtration.matchEverything())) {
                if (disjunction) {
                    return Filtration.matchEverything();
                }
                iterator.remove();
                continue;
            }
            if (!(child instanceof BoundDimFilter)) continue;
            BoundDimFilter bound = (BoundDimFilter)child;
            boundRefKey = BoundRefKey.from(bound);
            filterList = (List)bounds.get(boundRefKey);
            if (filterList == null) {
                filterList = Lists.newArrayList();
                bounds.put(boundRefKey, filterList);
            }
            filterList.add(bound);
        }
        for (Map.Entry entry : bounds.entrySet()) {
            boundRefKey = (BoundRefKey)entry.getKey();
            filterList = (List)entry.getValue();
            RangeSet rangeSet = disjunction ? RangeSets.unionRanges(Bounds.toRanges(filterList)) : RangeSets.intersectRanges(Bounds.toRanges(filterList));
            if (rangeSet.asRanges().size() >= filterList.size()) continue;
            for (BoundDimFilter bound : filterList) {
                if (newChildren.remove(bound)) continue;
                throw new ISE("WTF?! Tried to remove bound but couldn't?", new Object[0]);
            }
            if (rangeSet.asRanges().isEmpty()) {
                if (disjunction) {
                    newChildren.add(Filtration.matchNothing());
                } else {
                    return Filtration.matchNothing();
                }
            }
            for (Range range : rangeSet.asRanges()) {
                if (!range.hasLowerBound() && !range.hasUpperBound()) {
                    if (disjunction) {
                        return Filtration.matchEverything();
                    }
                    newChildren.add(Filtration.matchEverything());
                    continue;
                }
                newChildren.add(Bounds.toFilter(boundRefKey, (Range<BoundValue>)range));
            }
        }
        Preconditions.checkState((newChildren.size() > 0 ? 1 : 0) != 0, (Object)"newChildren.size > 0");
        if (newChildren.size() == 1) {
            return (DimFilter)newChildren.get(0);
        }
        return disjunction ? new OrDimFilter((List)newChildren) : new AndDimFilter((List)newChildren);
    }

    private static DimFilter negate(DimFilter filter) {
        if (Filtration.matchEverything().equals(filter)) {
            return Filtration.matchNothing();
        }
        if (Filtration.matchNothing().equals(filter)) {
            return Filtration.matchEverything();
        }
        if (filter instanceof NotDimFilter) {
            return ((NotDimFilter)filter).getField();
        }
        if (filter instanceof BoundDimFilter) {
            BoundDimFilter negated = Bounds.not((BoundDimFilter)filter);
            return negated != null ? negated : new NotDimFilter(filter);
        }
        return new NotDimFilter(filter);
    }

    private static List<DimFilter> negateAll(List<DimFilter> children) {
        ArrayList newChildren = Lists.newArrayListWithCapacity((int)children.size());
        for (DimFilter child : children) {
            newChildren.add(CombineAndSimplifyBounds.negate(child));
        }
        return newChildren;
    }

    private static int computeCost(DimFilter filter) {
        if (filter instanceof NotDimFilter) {
            return CombineAndSimplifyBounds.computeCost(((NotDimFilter)filter).getField());
        }
        if (filter instanceof AndDimFilter) {
            int cost = 0;
            for (DimFilter field : ((AndDimFilter)filter).getFields()) {
                cost += CombineAndSimplifyBounds.computeCost(field);
            }
            return cost;
        }
        if (filter instanceof OrDimFilter) {
            int cost = 0;
            for (DimFilter field : ((OrDimFilter)filter).getFields()) {
                cost += CombineAndSimplifyBounds.computeCost(field);
            }
            return cost;
        }
        return 1;
    }
}

