/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.filtration;

import io.druid.query.filter.BoundDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.query.ordering.StringComparator;
import io.druid.sql.calcite.expression.SimpleExtraction;
import io.druid.sql.calcite.filtration.BottomUpTransform;
import io.druid.sql.calcite.table.RowSignature;

public class ConvertBoundsToSelectors
extends BottomUpTransform {
    private final RowSignature sourceRowSignature;

    private ConvertBoundsToSelectors(RowSignature sourceRowSignature) {
        this.sourceRowSignature = sourceRowSignature;
    }

    public static ConvertBoundsToSelectors create(RowSignature sourceRowSignature) {
        return new ConvertBoundsToSelectors(sourceRowSignature);
    }

    @Override
    public DimFilter process(DimFilter filter) {
        if (filter instanceof BoundDimFilter) {
            BoundDimFilter bound = (BoundDimFilter)filter;
            StringComparator naturalStringComparator = this.sourceRowSignature.naturalStringComparator(SimpleExtraction.of(bound.getDimension(), bound.getExtractionFn()));
            if (bound.hasUpperBound() && bound.hasLowerBound() && bound.getUpper().equals(bound.getLower()) && !bound.isUpperStrict() && !bound.isLowerStrict() && bound.getOrdering().equals(naturalStringComparator)) {
                return new SelectorDimFilter(bound.getDimension(), bound.getUpper(), bound.getExtractionFn());
            }
            return filter;
        }
        return filter;
    }
}

