/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.filtration;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.druid.java.util.common.ISE;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.InDimFilter;
import io.druid.query.filter.OrDimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.sql.calcite.expression.SimpleExtraction;
import io.druid.sql.calcite.filtration.BottomUpTransform;
import io.druid.sql.calcite.filtration.BoundRefKey;
import io.druid.sql.calcite.table.RowSignature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConvertSelectorsToIns
extends BottomUpTransform {
    private final RowSignature sourceRowSignature;

    private ConvertSelectorsToIns(RowSignature sourceRowSignature) {
        this.sourceRowSignature = sourceRowSignature;
    }

    public static ConvertSelectorsToIns create(RowSignature sourceRowSignature) {
        return new ConvertSelectorsToIns(sourceRowSignature);
    }

    @Override
    public DimFilter process(DimFilter filter) {
        if (filter instanceof OrDimFilter) {
            ArrayList children = Lists.newArrayList((Iterable)((OrDimFilter)filter).getFields());
            HashMap selectors = Maps.newHashMap();
            for (DimFilter dimFilter : children) {
                if (!(dimFilter instanceof SelectorDimFilter)) continue;
                SelectorDimFilter selector = (SelectorDimFilter)dimFilter;
                BoundRefKey boundRefKey = BoundRefKey.from(selector, this.sourceRowSignature.naturalStringComparator(SimpleExtraction.of(selector.getDimension(), selector.getExtractionFn())));
                List filterList = (List)selectors.get(boundRefKey);
                if (filterList == null) {
                    filterList = Lists.newArrayList();
                    selectors.put(boundRefKey, filterList);
                }
                filterList.add(selector);
            }
            for (Map.Entry entry : selectors.entrySet()) {
                List filterList = (List)entry.getValue();
                if (filterList.size() <= 1) continue;
                ArrayList values = Lists.newArrayList();
                for (SelectorDimFilter selector : filterList) {
                    values.add(selector.getValue());
                    if (children.remove(selector)) continue;
                    throw new ISE("WTF?! Tried to remove selector but couldn't?", new Object[0]);
                }
                children.add(new InDimFilter(((BoundRefKey)entry.getKey()).getDimension(), (Collection)values, ((BoundRefKey)entry.getKey()).getExtractionFn()));
            }
            if (!children.equals(((OrDimFilter)filter).getFields())) {
                return children.size() == 1 ? (DimFilter)children.get(0) : new OrDimFilter((List)children);
            }
            return filter;
        }
        return filter;
    }
}

