/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.filtration;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.Intervals;
import io.druid.math.expr.ExprMacroTable;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.ExpressionDimFilter;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.sql.calcite.filtration.CombineAndSimplifyBounds;
import io.druid.sql.calcite.filtration.ConvertBoundsToSelectors;
import io.druid.sql.calcite.filtration.ConvertSelectorsToIns;
import io.druid.sql.calcite.filtration.MoveMarkerFiltersToIntervals;
import io.druid.sql.calcite.filtration.MoveTimeFiltersToIntervals;
import io.druid.sql.calcite.filtration.ValidateNoMarkerFiltersRemain;
import io.druid.sql.calcite.table.RowSignature;
import java.util.List;
import org.joda.time.Interval;

public class Filtration {
    private static final DimFilter MATCH_NOTHING = new ExpressionDimFilter("1 == 2", ExprMacroTable.nil());
    private static final DimFilter MATCH_EVERYTHING = new ExpressionDimFilter("1 == 1", ExprMacroTable.nil());
    private final DimFilter dimFilter;
    private final List<Interval> intervals;

    private Filtration(DimFilter dimFilter, List<Interval> intervals) {
        this.intervals = intervals != null ? intervals : Intervals.ONLY_ETERNITY;
        this.dimFilter = dimFilter;
    }

    public static Interval eternity() {
        return Intervals.ETERNITY;
    }

    public static DimFilter matchNothing() {
        return MATCH_NOTHING;
    }

    public static DimFilter matchEverything() {
        return MATCH_EVERYTHING;
    }

    public static Filtration create(DimFilter dimFilter) {
        return new Filtration(dimFilter, null);
    }

    public static Filtration create(DimFilter dimFilter, List<Interval> intervals) {
        return new Filtration(dimFilter, intervals);
    }

    private static Filtration transform(Filtration filtration, List<Function<Filtration, Filtration>> fns) {
        Filtration retVal = filtration;
        for (Function<Filtration, Filtration> fn : fns) {
            retVal = (Filtration)fn.apply((Object)retVal);
        }
        return retVal;
    }

    public QuerySegmentSpec getQuerySegmentSpec() {
        return new MultipleIntervalSegmentSpec(this.intervals);
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    public DimFilter getDimFilter() {
        return this.dimFilter;
    }

    public Filtration optimize(RowSignature sourceRowSignature) {
        return Filtration.transform(this, (List<Function<Filtration, Filtration>>)ImmutableList.of((Object)CombineAndSimplifyBounds.instance(), (Object)MoveTimeFiltersToIntervals.instance(), (Object)ConvertBoundsToSelectors.create(sourceRowSignature), (Object)ConvertSelectorsToIns.create(sourceRowSignature), (Object)MoveMarkerFiltersToIntervals.instance(), (Object)ValidateNoMarkerFiltersRemain.instance()));
    }

    public Filtration optimizeFilterOnly(RowSignature sourceRowSignature) {
        if (!this.intervals.equals(ImmutableList.of((Object)Filtration.eternity()))) {
            throw new ISE("Cannot optimizeFilterOnly when intervals are set", new Object[0]);
        }
        Filtration transformed = Filtration.transform(this, (List<Function<Filtration, Filtration>>)ImmutableList.of((Object)CombineAndSimplifyBounds.instance(), (Object)ConvertBoundsToSelectors.create(sourceRowSignature), (Object)ConvertSelectorsToIns.create(sourceRowSignature)));
        if (!transformed.getIntervals().equals(ImmutableList.of((Object)Filtration.eternity()))) {
            throw new ISE("WTF?! optimizeFilterOnly was about to return filtration with intervals?!", new Object[0]);
        }
        return transformed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Filtration that = (Filtration)o;
        if (this.intervals != null ? !this.intervals.equals(that.intervals) : that.intervals != null) {
            return false;
        }
        return this.dimFilter != null ? this.dimFilter.equals(that.dimFilter) : that.dimFilter == null;
    }

    public int hashCode() {
        int result = this.intervals != null ? this.intervals.hashCode() : 0;
        result = 31 * result + (this.dimFilter != null ? this.dimFilter.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Filtration{intervals=" + this.intervals + ", dimFilter=" + this.dimFilter + '}';
    }
}

