/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.filtration;

import com.google.common.base.Function;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import io.druid.java.util.common.Pair;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.BoundDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.NotDimFilter;
import io.druid.query.filter.OrDimFilter;
import io.druid.query.ordering.StringComparators;
import io.druid.sql.calcite.filtration.BoundRefKey;
import io.druid.sql.calcite.filtration.BoundValue;
import io.druid.sql.calcite.filtration.Bounds;
import io.druid.sql.calcite.filtration.Filtration;
import io.druid.sql.calcite.filtration.RangeSets;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.Interval;

public class MoveTimeFiltersToIntervals
implements Function<Filtration, Filtration> {
    private static final MoveTimeFiltersToIntervals INSTANCE = new MoveTimeFiltersToIntervals();
    private static final BoundRefKey TIME_BOUND_REF_KEY = new BoundRefKey("__time", null, StringComparators.NUMERIC);

    private MoveTimeFiltersToIntervals() {
    }

    public static MoveTimeFiltersToIntervals instance() {
        return INSTANCE;
    }

    public Filtration apply(Filtration filtration) {
        if (filtration.getDimFilter() == null) {
            return filtration;
        }
        RangeSet<Long> rangeSet = RangeSets.fromIntervals(filtration.getIntervals());
        rangeSet.removeAll(RangeSets.fromIntervals((Iterable<Interval>)ImmutableList.of((Object)Filtration.eternity())).complement());
        Pair<DimFilter, RangeSet<Long>> pair = MoveTimeFiltersToIntervals.extractConvertibleTimeBounds(filtration.getDimFilter());
        if (pair.rhs != null) {
            rangeSet.removeAll(((RangeSet)pair.rhs).complement());
        }
        return Filtration.create((DimFilter)pair.lhs, RangeSets.toIntervals(rangeSet));
    }

    private static Pair<DimFilter, RangeSet<Long>> extractConvertibleTimeBounds(DimFilter filter) {
        if (filter instanceof AndDimFilter) {
            List children = ((AndDimFilter)filter).getFields();
            ArrayList newChildren = Lists.newArrayList();
            ArrayList rangeSets = Lists.newArrayList();
            for (DimFilter child : children) {
                Pair<DimFilter, RangeSet<Long>> pair = MoveTimeFiltersToIntervals.extractConvertibleTimeBounds(child);
                if (pair.lhs != null) {
                    newChildren.add(pair.lhs);
                }
                if (pair.rhs == null) continue;
                rangeSets.add(pair.rhs);
            }
            Object newFilter = newChildren.size() == 0 ? null : (newChildren.size() == 1 ? (DimFilter)newChildren.get(0) : new AndDimFilter((List)newChildren));
            return Pair.of((Object)newFilter, rangeSets.isEmpty() ? null : RangeSets.intersectRangeSets(rangeSets));
        }
        if (filter instanceof OrDimFilter) {
            List children = ((OrDimFilter)filter).getFields();
            ArrayList rangeSets = Lists.newArrayList();
            boolean allCompletelyConverted = true;
            boolean allHadIntervals = true;
            for (DimFilter child : children) {
                Pair<DimFilter, RangeSet<Long>> pair = MoveTimeFiltersToIntervals.extractConvertibleTimeBounds(child);
                if (pair.lhs != null) {
                    allCompletelyConverted = false;
                }
                if (pair.rhs != null) {
                    rangeSets.add(pair.rhs);
                    continue;
                }
                allHadIntervals = false;
            }
            if (allCompletelyConverted) {
                return Pair.of(null, RangeSets.unionRangeSets(rangeSets));
            }
            return Pair.of((Object)filter, allHadIntervals ? RangeSets.unionRangeSets(rangeSets) : null);
        }
        if (filter instanceof NotDimFilter) {
            DimFilter child = ((NotDimFilter)filter).getField();
            Pair<DimFilter, RangeSet<Long>> pair = MoveTimeFiltersToIntervals.extractConvertibleTimeBounds(child);
            if (pair.rhs != null && pair.lhs == null) {
                return Pair.of(null, (Object)((RangeSet)pair.rhs).complement());
            }
            return Pair.of((Object)filter, null);
        }
        if (filter instanceof BoundDimFilter) {
            BoundDimFilter bound = (BoundDimFilter)filter;
            if (BoundRefKey.from(bound).equals(TIME_BOUND_REF_KEY)) {
                return Pair.of(null, RangeSets.of(MoveTimeFiltersToIntervals.toLongRange(Bounds.toRange(bound))));
            }
            return Pair.of((Object)filter, null);
        }
        return Pair.of((Object)filter, null);
    }

    private static Range<Long> toLongRange(Range<BoundValue> range) {
        if (!range.hasUpperBound() && !range.hasLowerBound()) {
            return Range.all();
        }
        if (range.hasUpperBound() && !range.hasLowerBound()) {
            return Range.upTo((Comparable)Long.valueOf(Long.parseLong(((BoundValue)range.upperEndpoint()).getValue())), (BoundType)range.upperBoundType());
        }
        if (!range.hasUpperBound() && range.hasLowerBound()) {
            return Range.downTo((Comparable)Long.valueOf(Long.parseLong(((BoundValue)range.lowerEndpoint()).getValue())), (BoundType)range.lowerBoundType());
        }
        return Range.range((Comparable)Long.valueOf(Long.parseLong(((BoundValue)range.lowerEndpoint()).getValue())), (BoundType)range.lowerBoundType(), (Comparable)Long.valueOf(Long.parseLong(((BoundValue)range.upperEndpoint()).getValue())), (BoundType)range.upperBoundType());
    }
}

