/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.planner;

import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Chars;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.StringUtils;
import io.druid.query.ordering.StringComparator;
import io.druid.query.ordering.StringComparators;
import io.druid.segment.column.ValueType;
import io.druid.server.security.AuthorizerMapper;
import io.druid.sql.calcite.schema.InformationSchema;
import java.nio.charset.Charset;
import java.util.NavigableSet;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ConversionUtil;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public class Calcites {
    private static final DateTimes.UtcFormatter CALCITE_DATE_PARSER = DateTimes.wrapFormatter((DateTimeFormatter)ISODateTimeFormat.dateParser());
    private static final DateTimes.UtcFormatter CALCITE_TIMESTAMP_PARSER = DateTimes.wrapFormatter((DateTimeFormatter)new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateParser()).appendLiteral(' ').append(ISODateTimeFormat.timeParser()).toFormatter());
    private static final DateTimeFormatter CALCITE_TIME_PRINTER = DateTimeFormat.forPattern((String)"HH:mm:ss.S");
    private static final DateTimeFormatter CALCITE_DATE_PRINTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final DateTimeFormatter CALCITE_TIMESTAMP_PRINTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.S");
    private static final Charset DEFAULT_CHARSET = Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME);

    private Calcites() {
    }

    public static void setSystemProperties() {
        String charset = ConversionUtil.NATIVE_UTF16_CHARSET_NAME;
        System.setProperty("saffron.default.charset", Calcites.defaultCharset().name());
        System.setProperty("saffron.default.nationalcharset", Calcites.defaultCharset().name());
        System.setProperty("saffron.default.collation.name", StringUtils.format((String)"%s$en_US", (Object[])new Object[]{charset}));
    }

    public static Charset defaultCharset() {
        return DEFAULT_CHARSET;
    }

    public static SchemaPlus createRootSchema(Schema druidSchema, AuthorizerMapper authorizerMapper) {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)false, (boolean)false).plus();
        rootSchema.add("druid", druidSchema);
        rootSchema.add("INFORMATION_SCHEMA", (Schema)new InformationSchema(rootSchema, authorizerMapper));
        return rootSchema;
    }

    public static String escapeStringLiteral(String s) {
        if (s == null) {
            return "''";
        }
        boolean isPlainAscii = true;
        StringBuilder builder = new StringBuilder("'");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == ' ') {
                builder.append(c);
                if (c <= '\u007f') continue;
                isPlainAscii = false;
                continue;
            }
            builder.append("\\").append(BaseEncoding.base16().encode(Chars.toByteArray((char)c)));
            isPlainAscii = false;
        }
        builder.append("'");
        return isPlainAscii ? builder.toString() : "U&" + builder.toString();
    }

    public static ValueType getValueTypeForSqlTypeName(SqlTypeName sqlTypeName) {
        if (SqlTypeName.FLOAT == sqlTypeName) {
            return ValueType.FLOAT;
        }
        if (SqlTypeName.FRACTIONAL_TYPES.contains(sqlTypeName)) {
            return ValueType.DOUBLE;
        }
        if (SqlTypeName.TIMESTAMP == sqlTypeName || SqlTypeName.DATE == sqlTypeName || SqlTypeName.BOOLEAN == sqlTypeName || SqlTypeName.INT_TYPES.contains(sqlTypeName)) {
            return ValueType.LONG;
        }
        if (SqlTypeName.CHAR_TYPES.contains(sqlTypeName)) {
            return ValueType.STRING;
        }
        if (SqlTypeName.OTHER == sqlTypeName) {
            return ValueType.COMPLEX;
        }
        return null;
    }

    public static StringComparator getStringComparatorForSqlTypeName(SqlTypeName sqlTypeName) {
        ValueType valueType = Calcites.getValueTypeForSqlTypeName(sqlTypeName);
        return Calcites.getStringComparatorForValueType(valueType);
    }

    public static StringComparator getStringComparatorForValueType(ValueType valueType) {
        if (ValueType.isNumeric((ValueType)valueType)) {
            return StringComparators.NUMERIC;
        }
        if (ValueType.STRING == valueType) {
            return StringComparators.LEXICOGRAPHIC;
        }
        throw new ISE("Unrecognized valueType[%s]", new Object[]{valueType});
    }

    public static RelDataType createSqlType(RelDataTypeFactory typeFactory, SqlTypeName typeName) {
        return Calcites.createSqlTypeWithNullability(typeFactory, typeName, false);
    }

    public static RelDataType createSqlTypeWithNullability(RelDataTypeFactory typeFactory, SqlTypeName typeName, boolean nullable) {
        RelDataType dataType;
        switch (typeName) {
            case TIMESTAMP: {
                dataType = typeFactory.createSqlType(typeName, 3);
                break;
            }
            case CHAR: 
            case VARCHAR: {
                dataType = typeFactory.createTypeWithCharsetAndCollation(typeFactory.createSqlType(typeName), Calcites.defaultCharset(), SqlCollation.IMPLICIT);
                break;
            }
            default: {
                dataType = typeFactory.createSqlType(typeName);
            }
        }
        return typeFactory.createTypeWithNullability(dataType, nullable);
    }

    public static long jodaToCalciteTimestamp(DateTime dateTime, DateTimeZone timeZone) {
        return dateTime.withZone(timeZone).withZoneRetainFields(DateTimeZone.UTC).getMillis();
    }

    public static int jodaToCalciteDate(DateTime dateTime, DateTimeZone timeZone) {
        DateTime date = dateTime.withZone(timeZone).dayOfMonth().roundFloorCopy();
        return Days.daysBetween((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)date.withZoneRetainFields(DateTimeZone.UTC)).getDays();
    }

    public static TimestampString jodaToCalciteTimestampString(DateTime dateTime, DateTimeZone timeZone) {
        return new TimestampString(CALCITE_TIMESTAMP_PRINTER.print((ReadableInstant)dateTime.withZone(timeZone)).replaceAll("\\.?0+$", ""));
    }

    public static TimeString jodaToCalciteTimeString(DateTime dateTime, DateTimeZone timeZone) {
        return new TimeString(CALCITE_TIME_PRINTER.print((ReadableInstant)dateTime.withZone(timeZone)).replaceAll("\\.?0+$", ""));
    }

    public static DateString jodaToCalciteDateString(DateTime dateTime, DateTimeZone timeZone) {
        return new DateString(CALCITE_DATE_PRINTER.print((ReadableInstant)dateTime.withZone(timeZone)));
    }

    public static DateTime calciteDateTimeLiteralToJoda(RexNode literal, DateTimeZone timeZone) {
        SqlTypeName typeName = literal.getType().getSqlTypeName();
        if (literal.getKind() != SqlKind.LITERAL || typeName != SqlTypeName.TIMESTAMP && typeName != SqlTypeName.DATE) {
            throw new IAE("Expected literal but got[%s]", new Object[]{literal.getKind()});
        }
        if (typeName == SqlTypeName.TIMESTAMP) {
            TimestampString timestampString = (TimestampString)RexLiteral.value((RexNode)literal);
            return CALCITE_TIMESTAMP_PARSER.parse(timestampString.toString()).withZoneRetainFields(timeZone);
        }
        if (typeName == SqlTypeName.DATE) {
            DateString dateString = (DateString)RexLiteral.value((RexNode)literal);
            return CALCITE_DATE_PARSER.parse(dateString.toString()).withZoneRetainFields(timeZone);
        }
        throw new IAE("Expected TIMESTAMP or DATE but got[%s]", new Object[]{typeName});
    }

    public static DateTime calciteTimestampToJoda(long timestamp, DateTimeZone timeZone) {
        return new DateTime(timestamp, DateTimeZone.UTC).withZoneRetainFields(timeZone);
    }

    public static DateTime calciteDateToJoda(int date, DateTimeZone timeZone) {
        return DateTimes.EPOCH.plusDays(date).withZoneRetainFields(timeZone);
    }

    public static boolean isIntLiteral(RexNode rexNode) {
        return rexNode instanceof RexLiteral && SqlTypeName.INT_TYPES.contains(rexNode.getType().getSqlTypeName());
    }

    public static String findUnusedPrefix(String basePrefix, NavigableSet<String> strings) {
        String prefix = basePrefix;
        while (!Calcites.isUnusedPrefix(prefix, strings)) {
            prefix = "_" + prefix;
        }
        return prefix;
    }

    private static boolean isUnusedPrefix(String prefix, NavigableSet<String> strings) {
        NavigableSet<String> subSet = strings.subSet(prefix + "0", true, prefix + ":", false);
        return subSet.isEmpty();
    }

    public static String makePrefixedName(String prefix, String suffix) {
        return StringUtils.format((String)"%s:%s", (Object[])new Object[]{prefix, suffix});
    }
}

