/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.StringUtils;
import io.druid.sql.calcite.aggregation.SqlAggregator;
import io.druid.sql.calcite.aggregation.builtin.ApproxCountDistinctSqlAggregator;
import io.druid.sql.calcite.aggregation.builtin.AvgSqlAggregator;
import io.druid.sql.calcite.aggregation.builtin.CountSqlAggregator;
import io.druid.sql.calcite.aggregation.builtin.MaxSqlAggregator;
import io.druid.sql.calcite.aggregation.builtin.MinSqlAggregator;
import io.druid.sql.calcite.aggregation.builtin.SumSqlAggregator;
import io.druid.sql.calcite.aggregation.builtin.SumZeroSqlAggregator;
import io.druid.sql.calcite.expression.AliasedOperatorConversion;
import io.druid.sql.calcite.expression.BinaryOperatorConversion;
import io.druid.sql.calcite.expression.DirectOperatorConversion;
import io.druid.sql.calcite.expression.SqlOperatorConversion;
import io.druid.sql.calcite.expression.UnaryPrefixOperatorConversion;
import io.druid.sql.calcite.expression.UnarySuffixOperatorConversion;
import io.druid.sql.calcite.expression.builtin.BTrimOperatorConversion;
import io.druid.sql.calcite.expression.builtin.CastOperatorConversion;
import io.druid.sql.calcite.expression.builtin.CeilOperatorConversion;
import io.druid.sql.calcite.expression.builtin.DateTruncOperatorConversion;
import io.druid.sql.calcite.expression.builtin.ExtractOperatorConversion;
import io.druid.sql.calcite.expression.builtin.FloorOperatorConversion;
import io.druid.sql.calcite.expression.builtin.LTrimOperatorConversion;
import io.druid.sql.calcite.expression.builtin.MillisToTimestampOperatorConversion;
import io.druid.sql.calcite.expression.builtin.RTrimOperatorConversion;
import io.druid.sql.calcite.expression.builtin.RegexpExtractOperatorConversion;
import io.druid.sql.calcite.expression.builtin.ReinterpretOperatorConversion;
import io.druid.sql.calcite.expression.builtin.StrposOperatorConversion;
import io.druid.sql.calcite.expression.builtin.SubstringOperatorConversion;
import io.druid.sql.calcite.expression.builtin.TimeArithmeticOperatorConversion;
import io.druid.sql.calcite.expression.builtin.TimeExtractOperatorConversion;
import io.druid.sql.calcite.expression.builtin.TimeFloorOperatorConversion;
import io.druid.sql.calcite.expression.builtin.TimeFormatOperatorConversion;
import io.druid.sql.calcite.expression.builtin.TimeParseOperatorConversion;
import io.druid.sql.calcite.expression.builtin.TimeShiftOperatorConversion;
import io.druid.sql.calcite.expression.builtin.TimestampToMillisOperatorConversion;
import io.druid.sql.calcite.expression.builtin.TrimOperatorConversion;
import io.druid.sql.calcite.expression.builtin.TruncateOperatorConversion;
import io.druid.sql.calcite.planner.DruidConvertletTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class DruidOperatorTable
implements SqlOperatorTable {
    private static final List<SqlAggregator> STANDARD_AGGREGATORS = ImmutableList.builder().add((Object)new ApproxCountDistinctSqlAggregator()).add((Object)new AvgSqlAggregator()).add((Object)new CountSqlAggregator()).add((Object)new MinSqlAggregator()).add((Object)new MaxSqlAggregator()).add((Object)new SumSqlAggregator()).add((Object)new SumZeroSqlAggregator()).build();
    private static final SqlOperatorConversion CHARACTER_LENGTH_CONVERSION = new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.CHARACTER_LENGTH, "strlen");
    private static final List<SqlOperatorConversion> STANDARD_OPERATOR_CONVERSIONS = ImmutableList.builder().add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.ABS, "abs")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.CASE, "case_searched")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, "strlen")).add((Object)CHARACTER_LENGTH_CONVERSION).add((Object)new AliasedOperatorConversion(CHARACTER_LENGTH_CONVERSION, "LENGTH")).add((Object)new AliasedOperatorConversion(CHARACTER_LENGTH_CONVERSION, "STRLEN")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.CONCAT, "concat")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.EXP, "exp")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, "div")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.LIKE, "like")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.LN, "log")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.LOWER, "lower")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.LOG10, "log10")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.POWER, "pow")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.REPLACE, "replace")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.SQRT, "sqrt")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.UPPER, "upper")).add((Object)new UnaryPrefixOperatorConversion((SqlOperator)SqlStdOperatorTable.NOT, "!")).add((Object)new UnaryPrefixOperatorConversion((SqlOperator)SqlStdOperatorTable.UNARY_MINUS, "-")).add((Object)new UnarySuffixOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_NULL, "== ''")).add((Object)new UnarySuffixOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, "!= ''")).add((Object)new UnarySuffixOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_FALSE, "<= 0")).add((Object)new UnarySuffixOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_NOT_TRUE, "<= 0")).add((Object)new UnarySuffixOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_TRUE, "> 0")).add((Object)new UnarySuffixOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_NOT_FALSE, "> 0")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.MULTIPLY, "*")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.MOD, "%")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.DIVIDE, "/")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.PLUS, "+")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.MINUS, "-")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.EQUALS, "==")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, "!=")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.GREATER_THAN, ">")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, ">=")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.LESS_THAN, "<")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, "<=")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.AND, "&&")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.OR, "||")).add((Object)new CastOperatorConversion()).add((Object)new CeilOperatorConversion()).add((Object)new DateTruncOperatorConversion()).add((Object)new ExtractOperatorConversion()).add((Object)new FloorOperatorConversion()).add((Object)new MillisToTimestampOperatorConversion()).add((Object)new ReinterpretOperatorConversion()).add((Object)new RegexpExtractOperatorConversion()).add((Object)new StrposOperatorConversion()).add((Object)new SubstringOperatorConversion()).add((Object)new AliasedOperatorConversion(new SubstringOperatorConversion(), "SUBSTR")).add((Object)new TimeArithmeticOperatorConversion.TimeMinusIntervalOperatorConversion()).add((Object)new TimeArithmeticOperatorConversion.TimePlusIntervalOperatorConversion()).add((Object)new TimeExtractOperatorConversion()).add((Object)new TimeFloorOperatorConversion()).add((Object)new TimeFormatOperatorConversion()).add((Object)new TimeParseOperatorConversion()).add((Object)new TimeShiftOperatorConversion()).add((Object)new TimestampToMillisOperatorConversion()).add((Object)new TruncateOperatorConversion()).add((Object)new TrimOperatorConversion()).add((Object)new BTrimOperatorConversion()).add((Object)new LTrimOperatorConversion()).add((Object)new RTrimOperatorConversion()).add((Object)new AliasedOperatorConversion(new TruncateOperatorConversion(), "TRUNC")).build();
    private static final Map<OperatorKey, SqlOperator> CONVERTLET_OPERATORS = DruidConvertletTable.knownOperators().stream().collect(Collectors.toMap(OperatorKey::of, Function.identity()));
    private final Map<OperatorKey, SqlAggregator> aggregators = Maps.newHashMap();
    private final Map<OperatorKey, SqlOperatorConversion> operatorConversions = Maps.newHashMap();

    @Inject
    public DruidOperatorTable(Set<SqlAggregator> aggregators, Set<SqlOperatorConversion> operatorConversions) {
        OperatorKey operatorKey;
        for (SqlAggregator aggregator : aggregators) {
            operatorKey = OperatorKey.of((SqlOperator)aggregator.calciteFunction());
            if (this.aggregators.put(operatorKey, aggregator) == null) continue;
            throw new ISE("Cannot have two operators with key[%s]", new Object[]{operatorKey});
        }
        for (SqlAggregator aggregator : STANDARD_AGGREGATORS) {
            operatorKey = OperatorKey.of((SqlOperator)aggregator.calciteFunction());
            this.aggregators.putIfAbsent(operatorKey, aggregator);
        }
        for (SqlOperatorConversion operatorConversion : operatorConversions) {
            operatorKey = OperatorKey.of(operatorConversion.calciteOperator());
            if (!this.aggregators.containsKey(operatorKey) && this.operatorConversions.put(operatorKey, operatorConversion) == null) continue;
            throw new ISE("Cannot have two operators with key[%s]", new Object[]{operatorKey});
        }
        for (SqlOperatorConversion operatorConversion : STANDARD_OPERATOR_CONVERSIONS) {
            operatorKey = OperatorKey.of(operatorConversion.calciteOperator());
            if (this.aggregators.containsKey(operatorKey)) continue;
            this.operatorConversions.putIfAbsent(operatorKey, operatorConversion);
        }
    }

    public SqlAggregator lookupAggregator(SqlAggFunction aggFunction) {
        SqlAggregator sqlAggregator = this.aggregators.get(OperatorKey.of((SqlOperator)aggFunction));
        if (sqlAggregator != null && sqlAggregator.calciteFunction().equals((Object)aggFunction)) {
            return sqlAggregator;
        }
        return null;
    }

    public SqlOperatorConversion lookupOperatorConversion(SqlOperator operator) {
        SqlOperatorConversion operatorConversion = this.operatorConversions.get(OperatorKey.of(operator));
        if (operatorConversion != null && operatorConversion.calciteOperator().equals((Object)operator)) {
            return operatorConversion;
        }
        return null;
    }

    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList) {
        SqlOperator convertletOperator;
        SqlOperatorConversion operatorConversion;
        if (opName.names.size() != 1) {
            return;
        }
        OperatorKey operatorKey = OperatorKey.of(opName.getSimple(), syntax);
        SqlAggregator aggregator = this.aggregators.get(operatorKey);
        if (aggregator != null) {
            operatorList.add((SqlOperator)aggregator.calciteFunction());
        }
        if ((operatorConversion = this.operatorConversions.get(operatorKey)) != null) {
            operatorList.add(operatorConversion.calciteOperator());
        }
        if ((convertletOperator = CONVERTLET_OPERATORS.get(operatorKey)) != null) {
            operatorList.add(convertletOperator);
        }
    }

    public List<SqlOperator> getOperatorList() {
        ArrayList<SqlOperator> retVal = new ArrayList<SqlOperator>();
        for (SqlAggregator aggregator : this.aggregators.values()) {
            retVal.add((SqlOperator)aggregator.calciteFunction());
        }
        for (SqlOperatorConversion operatorConversion : this.operatorConversions.values()) {
            retVal.add(operatorConversion.calciteOperator());
        }
        retVal.addAll(DruidConvertletTable.knownOperators());
        return retVal;
    }

    private static SqlSyntax normalizeSyntax(SqlSyntax syntax) {
        if (syntax == SqlSyntax.PREFIX || syntax == SqlSyntax.BINARY || syntax == SqlSyntax.POSTFIX) {
            return syntax;
        }
        return SqlSyntax.FUNCTION;
    }

    private static class OperatorKey {
        private final String name;
        private final SqlSyntax syntax;

        public OperatorKey(String name, SqlSyntax syntax) {
            this.name = StringUtils.toLowerCase((String)((String)Preconditions.checkNotNull((Object)name, (Object)"name")));
            this.syntax = DruidOperatorTable.normalizeSyntax((SqlSyntax)Preconditions.checkNotNull((Object)syntax, (Object)"syntax"));
        }

        public static OperatorKey of(String name, SqlSyntax syntax) {
            return new OperatorKey(name, syntax);
        }

        public static OperatorKey of(SqlOperator operator) {
            return new OperatorKey(operator.getName(), operator.getSyntax());
        }

        public String getName() {
            return this.name;
        }

        public SqlSyntax getSyntax() {
            return this.syntax;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorKey that = (OperatorKey)o;
            return Objects.equals(this.name, that.name) && this.syntax == that.syntax;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.syntax);
        }

        public String toString() {
            return "OperatorKey{name='" + this.name + '\'' + ", syntax=" + this.syntax + '}';
        }
    }
}

