/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.planner;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.server.security.Access;
import io.druid.server.security.AuthenticationResult;
import io.druid.server.security.AuthorizationUtils;
import io.druid.server.security.AuthorizerMapper;
import io.druid.server.security.Escalator;
import io.druid.server.security.ForbiddenException;
import io.druid.sql.calcite.planner.Calcites;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.planner.PlannerResult;
import io.druid.sql.calcite.rel.DruidConvention;
import io.druid.sql.calcite.rel.DruidRel;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.interpreter.BindableRel;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;

public class DruidPlanner
implements Closeable {
    private final Planner planner;
    private final PlannerContext plannerContext;
    private final AuthorizerMapper authorizerMapper;
    private final Escalator escalator;

    public DruidPlanner(Planner planner, PlannerContext plannerContext, AuthorizerMapper authorizerMapper, Escalator escalator) {
        this.planner = planner;
        this.plannerContext = plannerContext;
        this.authorizerMapper = authorizerMapper;
        this.escalator = escalator;
    }

    public PlannerResult plan(String sql) throws SqlParseException, ValidationException, RelConversionException {
        AuthenticationResult authenticationResult = this.escalator.createEscalatedAuthenticationResult();
        return this.plan(sql, null, authenticationResult);
    }

    public PlannerResult plan(String sql, HttpServletRequest request, AuthenticationResult authenticationResult) throws SqlParseException, ValidationException, RelConversionException, ForbiddenException {
        SqlExplain explain = null;
        SqlNode parsed = this.planner.parse(sql);
        if (parsed.getKind() == SqlKind.EXPLAIN) {
            explain = (SqlExplain)parsed;
            parsed = explain.getExplicandum();
        }
        SqlNode validated = this.planner.validate(parsed);
        RelRoot root = this.planner.rel(validated);
        try {
            return this.planWithDruidConvention(explain, root, request, authenticationResult);
        }
        catch (RelOptPlanner.CannotPlanException e) {
            try {
                return this.planWithBindableConvention(explain, root, request, authenticationResult);
            }
            catch (Exception e2) {
                e.addSuppressed((Throwable)e2);
                throw e;
            }
        }
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    @Override
    public void close() {
        this.planner.close();
    }

    private PlannerResult planWithDruidConvention(SqlExplain explain, final RelRoot root, HttpServletRequest request, AuthenticationResult authenticationResult) throws RelConversionException, ForbiddenException {
        Access authResult;
        final DruidRel druidRel = (DruidRel)this.planner.transform(0, this.planner.getEmptyTraitSet().replace((RelTrait)DruidConvention.instance()).plus((RelTrait)root.collation), root.rel);
        List<String> datasourceNames = druidRel.getDatasourceNames();
        if (request != null) {
            authResult = AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)request, (Iterable)Iterables.transform(datasourceNames, (Function)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR), (AuthorizerMapper)this.authorizerMapper);
            this.plannerContext.setAuthenticationResult((AuthenticationResult)request.getAttribute("Druid-Authentication-Result"));
        } else {
            authResult = AuthorizationUtils.authorizeAllResourceActions((AuthenticationResult)authenticationResult, (Iterable)Iterables.transform(datasourceNames, (Function)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR), (AuthorizerMapper)this.authorizerMapper);
            this.plannerContext.setAuthenticationResult(authenticationResult);
        }
        if (!authResult.isAllowed()) {
            throw new ForbiddenException(authResult.toString());
        }
        if (explain != null) {
            return this.planExplanation((RelNode)druidRel, explain);
        }
        Supplier<Sequence<Object[]>> resultsSupplier = new Supplier<Sequence<Object[]>>(){

            public Sequence<Object[]> get() {
                if (root.isRefTrivial()) {
                    return druidRel.runQuery();
                }
                return Sequences.map(druidRel.runQuery(), (Function)new Function<Object[], Object[]>(){

                    public Object[] apply(Object[] input) {
                        Object[] retVal = new Object[root.fields.size()];
                        for (int i = 0; i < root.fields.size(); ++i) {
                            retVal[i] = input[(Integer)((Pair)root.fields.get(i)).getKey()];
                        }
                        return retVal;
                    }
                });
            }
        };
        return new PlannerResult(resultsSupplier, root.validatedRowType);
    }

    private Access authorizeBindableRel(BindableRel rel, PlannerContext plannerContext, HttpServletRequest req, AuthenticationResult authenticationResult) {
        final HashSet datasourceNames = Sets.newHashSet();
        rel.childrenAccept(new RelVisitor(){

            public void visit(RelNode node, int ordinal, RelNode parent) {
                if (node instanceof DruidRel) {
                    datasourceNames.addAll(((DruidRel)node).getDatasourceNames());
                }
                if (node instanceof Bindables.BindableTableScan) {
                    Bindables.BindableTableScan bts = (Bindables.BindableTableScan)node;
                    RelOptTable table = bts.getTable();
                    String tableName = (String)table.getQualifiedName().get(0);
                    datasourceNames.add(tableName);
                }
                node.childrenAccept((RelVisitor)this);
            }
        });
        if (req != null) {
            plannerContext.setAuthenticationResult((AuthenticationResult)req.getAttribute("Druid-Authentication-Result"));
            return AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)req, (Iterable)Iterables.transform((Iterable)datasourceNames, (Function)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR), (AuthorizerMapper)this.authorizerMapper);
        }
        plannerContext.setAuthenticationResult(authenticationResult);
        return AuthorizationUtils.authorizeAllResourceActions((AuthenticationResult)authenticationResult, (Iterable)Iterables.transform((Iterable)datasourceNames, (Function)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR), (AuthorizerMapper)this.authorizerMapper);
    }

    private PlannerResult planWithBindableConvention(SqlExplain explain, RelRoot root, HttpServletRequest request, AuthenticationResult authenticationResult) throws RelConversionException {
        Access accessResult;
        BindableRel bindableRel = (BindableRel)this.planner.transform(1, this.planner.getEmptyTraitSet().replace((RelTrait)BindableConvention.INSTANCE).plus((RelTrait)root.collation), root.rel);
        if (!root.isRefTrivial()) {
            ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
            RexBuilder rexBuilder = bindableRel.getCluster().getRexBuilder();
            Iterator iterator = Pair.left((List)root.fields).iterator();
            while (iterator.hasNext()) {
                int field = (Integer)iterator.next();
                projects.add(rexBuilder.makeInputRef((RelNode)bindableRel, field));
            }
            bindableRel = new Bindables.BindableProject(bindableRel.getCluster(), bindableRel.getTraitSet(), (RelNode)bindableRel, projects, root.validatedRowType);
        }
        if (!(accessResult = this.authorizeBindableRel(bindableRel, this.plannerContext, request, authenticationResult)).isAllowed()) {
            throw new ForbiddenException(accessResult.toString());
        }
        if (explain != null) {
            return this.planExplanation((RelNode)bindableRel, explain);
        }
        final BindableRel theRel = bindableRel;
        final DataContext dataContext = this.plannerContext.createDataContext((JavaTypeFactory)this.planner.getTypeFactory());
        Supplier<Sequence<Object[]>> resultsSupplier = new Supplier<Sequence<Object[]>>(){

            public Sequence<Object[]> get() {
                Enumerable enumerable = theRel.bind(dataContext);
                return Sequences.simple((Iterable)enumerable);
            }
        };
        return new PlannerResult(resultsSupplier, root.validatedRowType);
    }

    private PlannerResult planExplanation(RelNode rel, SqlExplain explain) {
        String explanation = RelOptUtil.dumpPlan((String)"", (RelNode)rel, (SqlExplainFormat)explain.getFormat(), (SqlExplainLevel)explain.getDetailLevel());
        Supplier resultsSupplier = Suppliers.ofInstance((Object)Sequences.simple((Iterable)ImmutableList.of((Object)new Object[]{explanation})));
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        return new PlannerResult((Supplier<Sequence<Object[]>>)resultsSupplier, typeFactory.createStructType((List)ImmutableList.of((Object)Calcites.createSqlType(typeFactory, SqlTypeName.VARCHAR)), (List)ImmutableList.of((Object)"PLAN")));
    }
}

