/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.planner;

import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.IAE;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprEval;
import io.druid.math.expr.ExprMacroTable;
import io.druid.math.expr.ExprType;
import io.druid.math.expr.Parser;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.Expressions;
import io.druid.sql.calcite.planner.Calcites;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;

public class DruidRexExecutor
implements RexExecutor {
    private static final RowSignature EMPTY_ROW_SIGNATURE = RowSignature.builder().build();
    private final PlannerContext plannerContext;

    public DruidRexExecutor(PlannerContext plannerContext) {
        this.plannerContext = plannerContext;
    }

    public void reduce(RexBuilder rexBuilder, List<RexNode> constExps, List<RexNode> reducedValues) {
        for (RexNode constExp : constExps) {
            RexNode literal;
            DruidExpression druidExpression = Expressions.toDruidExpression(this.plannerContext, EMPTY_ROW_SIGNATURE, constExp);
            if (druidExpression == null) {
                reducedValues.add(constExp);
                continue;
            }
            SqlTypeName sqlTypeName = constExp.getType().getSqlTypeName();
            Expr expr = Parser.parse((String)druidExpression.getExpression(), (ExprMacroTable)this.plannerContext.getExprMacroTable());
            ExprEval exprResult = expr.eval(name -> {
                throw new UnsupportedOperationException();
            });
            if (sqlTypeName == SqlTypeName.BOOLEAN) {
                literal = rexBuilder.makeLiteral((Object)exprResult.asBoolean(), constExp.getType(), true);
            } else if (sqlTypeName == SqlTypeName.DATE) {
                if (!constExp.getType().isNullable() && exprResult.isNull()) {
                    throw new IAE("Illegal DATE constant: %s", new Object[]{constExp});
                }
                literal = rexBuilder.makeDateLiteral(Calcites.jodaToCalciteDateString(DateTimes.utc((long)exprResult.asLong()), this.plannerContext.getTimeZone()));
            } else if (sqlTypeName == SqlTypeName.TIMESTAMP) {
                if (!constExp.getType().isNullable() && exprResult.isNull()) {
                    throw new IAE("Illegal TIMESTAMP constant: %s", new Object[]{constExp});
                }
                literal = rexBuilder.makeTimestampLiteral(Calcites.jodaToCalciteTimestampString(DateTimes.utc((long)exprResult.asLong()), this.plannerContext.getTimeZone()), -1);
            } else if (SqlTypeName.NUMERIC_TYPES.contains(sqlTypeName)) {
                BigDecimal bigDecimal = exprResult.type() == ExprType.LONG ? BigDecimal.valueOf(exprResult.asLong()) : BigDecimal.valueOf(exprResult.asDouble());
                literal = rexBuilder.makeLiteral((Object)bigDecimal, constExp.getType(), true);
            } else {
                literal = rexBuilder.makeLiteral(exprResult.value(), constExp.getType(), true);
            }
            reducedValues.add(literal);
        }
    }
}

