/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.planner;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.java.util.common.IAE;
import java.util.Map;
import org.joda.time.Period;

public class PlannerConfig {
    public static final String CTX_KEY_USE_APPROXIMATE_COUNT_DISTINCT = "useApproximateCountDistinct";
    public static final String CTX_KEY_USE_APPROXIMATE_TOPN = "useApproximateTopN";
    public static final String CTX_KEY_USE_FALLBACK = "useFallback";
    @JsonProperty
    private Period metadataRefreshPeriod = new Period((Object)"PT1M");
    @JsonProperty
    private int maxSemiJoinRowsInMemory = 100000;
    @JsonProperty
    private int maxTopNLimit = 100000;
    @JsonProperty
    private int maxQueryCount = 8;
    @JsonProperty
    private int selectThreshold = 1000;
    @JsonProperty
    private boolean useApproximateCountDistinct = true;
    @JsonProperty
    private boolean useApproximateTopN = true;
    @JsonProperty
    private boolean useFallback = false;

    public Period getMetadataRefreshPeriod() {
        return this.metadataRefreshPeriod;
    }

    public int getMaxSemiJoinRowsInMemory() {
        return this.maxSemiJoinRowsInMemory;
    }

    public int getMaxTopNLimit() {
        return this.maxTopNLimit;
    }

    public int getMaxQueryCount() {
        return this.maxQueryCount;
    }

    public int getSelectThreshold() {
        return this.selectThreshold;
    }

    public boolean isUseApproximateCountDistinct() {
        return this.useApproximateCountDistinct;
    }

    public boolean isUseApproximateTopN() {
        return this.useApproximateTopN;
    }

    public boolean isUseFallback() {
        return this.useFallback;
    }

    public PlannerConfig withOverrides(Map<String, Object> context) {
        if (context == null) {
            return this;
        }
        PlannerConfig newConfig = new PlannerConfig();
        newConfig.metadataRefreshPeriod = this.getMetadataRefreshPeriod();
        newConfig.maxSemiJoinRowsInMemory = this.getMaxSemiJoinRowsInMemory();
        newConfig.maxTopNLimit = this.getMaxTopNLimit();
        newConfig.maxQueryCount = this.getMaxQueryCount();
        newConfig.selectThreshold = this.getSelectThreshold();
        newConfig.useApproximateCountDistinct = PlannerConfig.getContextBoolean(context, CTX_KEY_USE_APPROXIMATE_COUNT_DISTINCT, this.isUseApproximateCountDistinct());
        newConfig.useApproximateTopN = PlannerConfig.getContextBoolean(context, CTX_KEY_USE_APPROXIMATE_TOPN, this.isUseApproximateTopN());
        newConfig.useFallback = PlannerConfig.getContextBoolean(context, CTX_KEY_USE_FALLBACK, this.isUseFallback());
        return newConfig;
    }

    private static boolean getContextBoolean(Map<String, Object> context, String parameter, boolean defaultValue) {
        Object value = context.get(parameter);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IAE("Expected parameter[%s] to be boolean", new Object[]{parameter});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlannerConfig that = (PlannerConfig)o;
        if (this.maxSemiJoinRowsInMemory != that.maxSemiJoinRowsInMemory) {
            return false;
        }
        if (this.maxTopNLimit != that.maxTopNLimit) {
            return false;
        }
        if (this.maxQueryCount != that.maxQueryCount) {
            return false;
        }
        if (this.selectThreshold != that.selectThreshold) {
            return false;
        }
        if (this.useApproximateCountDistinct != that.useApproximateCountDistinct) {
            return false;
        }
        if (this.useApproximateTopN != that.useApproximateTopN) {
            return false;
        }
        if (this.useFallback != that.useFallback) {
            return false;
        }
        return this.metadataRefreshPeriod != null ? this.metadataRefreshPeriod.equals((Object)that.metadataRefreshPeriod) : that.metadataRefreshPeriod == null;
    }

    public int hashCode() {
        int result = this.metadataRefreshPeriod != null ? this.metadataRefreshPeriod.hashCode() : 0;
        result = 31 * result + this.maxSemiJoinRowsInMemory;
        result = 31 * result + this.maxTopNLimit;
        result = 31 * result + this.maxQueryCount;
        result = 31 * result + this.selectThreshold;
        result = 31 * result + (this.useApproximateCountDistinct ? 1 : 0);
        result = 31 * result + (this.useApproximateTopN ? 1 : 0);
        result = 31 * result + (this.useFallback ? 1 : 0);
        return result;
    }

    public String toString() {
        return "PlannerConfig{metadataRefreshPeriod=" + this.metadataRefreshPeriod + ", maxSemiJoinRowsInMemory=" + this.maxSemiJoinRowsInMemory + ", maxTopNLimit=" + this.maxTopNLimit + ", maxQueryCount=" + this.maxQueryCount + ", selectThreshold=" + this.selectThreshold + ", useApproximateCountDistinct=" + this.useApproximateCountDistinct + ", useApproximateTopN=" + this.useApproximateTopN + ", useFallback=" + this.useFallback + '}';
    }
}

