/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.druid.math.expr.ExprMacroTable;
import io.druid.server.security.AuthenticationResult;
import io.druid.server.security.AuthorizerMapper;
import io.druid.sql.calcite.planner.DruidOperatorTable;
import io.druid.sql.calcite.planner.PlannerConfig;
import java.util.Map;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.schema.SchemaPlus;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class PlannerContext {
    public static final String CTX_SQL_CURRENT_TIMESTAMP = "sqlCurrentTimestamp";
    public static final String CTX_SQL_TIME_ZONE = "sqlTimeZone";
    public static final String DATA_CTX_AUTHENTICATION_RESULT = "authenticationResult";
    private final DruidOperatorTable operatorTable;
    private final ExprMacroTable macroTable;
    private final PlannerConfig plannerConfig;
    private final DateTime localNow;
    private final long queryStartTimeMillis;
    private final Map<String, Object> queryContext;
    private final AuthorizerMapper authorizerMapper;
    private AuthenticationResult authenticationResult;

    private PlannerContext(DruidOperatorTable operatorTable, ExprMacroTable macroTable, PlannerConfig plannerConfig, DateTime localNow, AuthorizerMapper authorizerMapper, Map<String, Object> queryContext) {
        this.operatorTable = operatorTable;
        this.macroTable = macroTable;
        this.plannerConfig = (PlannerConfig)Preconditions.checkNotNull((Object)plannerConfig, (Object)"plannerConfig");
        this.queryContext = queryContext != null ? Maps.newHashMap(queryContext) : Maps.newHashMap();
        this.localNow = (DateTime)Preconditions.checkNotNull((Object)localNow, (Object)"localNow");
        this.queryStartTimeMillis = System.currentTimeMillis();
        this.authorizerMapper = authorizerMapper;
    }

    public static PlannerContext create(DruidOperatorTable operatorTable, ExprMacroTable macroTable, PlannerConfig plannerConfig, AuthorizerMapper authorizerMapper, Map<String, Object> queryContext) {
        DateTimeZone timeZone;
        DateTime utcNow;
        if (queryContext != null) {
            Object tsParam = queryContext.get(CTX_SQL_CURRENT_TIMESTAMP);
            Object tzParam = queryContext.get(CTX_SQL_TIME_ZONE);
            utcNow = tsParam != null ? new DateTime(tsParam, DateTimeZone.UTC) : new DateTime(DateTimeZone.UTC);
            timeZone = tzParam != null ? DateTimeZone.forID((String)String.valueOf(tzParam)) : DateTimeZone.UTC;
        } else {
            utcNow = new DateTime(DateTimeZone.UTC);
            timeZone = DateTimeZone.UTC;
        }
        return new PlannerContext(operatorTable, macroTable, plannerConfig.withOverrides(queryContext), utcNow.withZone(timeZone), authorizerMapper, queryContext);
    }

    public DruidOperatorTable getOperatorTable() {
        return this.operatorTable;
    }

    public ExprMacroTable getExprMacroTable() {
        return this.macroTable;
    }

    public PlannerConfig getPlannerConfig() {
        return this.plannerConfig;
    }

    public DateTime getLocalNow() {
        return this.localNow;
    }

    public DateTimeZone getTimeZone() {
        return this.localNow.getZone();
    }

    public Map<String, Object> getQueryContext() {
        return this.queryContext;
    }

    public long getQueryStartTimeMillis() {
        return this.queryStartTimeMillis;
    }

    public AuthenticationResult getAuthenticationResult() {
        return this.authenticationResult;
    }

    public void setAuthenticationResult(AuthenticationResult authenticationResult) {
        this.authenticationResult = authenticationResult;
    }

    public DataContext createDataContext(final JavaTypeFactory typeFactory) {
        class DruidDataContext
        implements DataContext {
            private final Map<String, Object> context;

            DruidDataContext() {
                this.context = ImmutableMap.of((Object)DataContext.Variable.UTC_TIMESTAMP.camelName, (Object)PlannerContext.this.localNow.getMillis(), (Object)DataContext.Variable.CURRENT_TIMESTAMP.camelName, (Object)PlannerContext.this.localNow.getMillis(), (Object)DataContext.Variable.LOCAL_TIMESTAMP.camelName, (Object)new Interval((ReadableInstant)new DateTime((Object)"1970-01-01T00:00:00.000", PlannerContext.this.localNow.getZone()), (ReadableInstant)PlannerContext.this.localNow).toDurationMillis(), (Object)DataContext.Variable.TIME_ZONE.camelName, (Object)PlannerContext.this.localNow.getZone().toTimeZone().clone(), (Object)PlannerContext.DATA_CTX_AUTHENTICATION_RESULT, (Object)PlannerContext.this.authenticationResult);
            }

            public SchemaPlus getRootSchema() {
                throw new UnsupportedOperationException();
            }

            public JavaTypeFactory getTypeFactory() {
                return typeFactory;
            }

            public QueryProvider getQueryProvider() {
                throw new UnsupportedOperationException();
            }

            public Object get(String name) {
                return this.context.get(name);
            }
        }
        return new DruidDataContext();
    }
}

