/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.planner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.druid.guice.annotations.Json;
import io.druid.math.expr.ExprMacroTable;
import io.druid.server.QueryLifecycleFactory;
import io.druid.server.security.AuthConfig;
import io.druid.server.security.AuthorizerMapper;
import io.druid.server.security.Escalator;
import io.druid.sql.calcite.planner.Calcites;
import io.druid.sql.calcite.planner.DruidConformance;
import io.druid.sql.calcite.planner.DruidConvertletTable;
import io.druid.sql.calcite.planner.DruidOperatorTable;
import io.druid.sql.calcite.planner.DruidPlanner;
import io.druid.sql.calcite.planner.DruidRexExecutor;
import io.druid.sql.calcite.planner.DruidTypeSystem;
import io.druid.sql.calcite.planner.PlannerConfig;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.planner.Rules;
import io.druid.sql.calcite.rel.QueryMaker;
import io.druid.sql.calcite.schema.DruidSchema;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;

public class PlannerFactory {
    private static final SqlParser.Config PARSER_CONFIG = SqlParser.configBuilder().setCaseSensitive(true).setUnquotedCasing(Casing.UNCHANGED).setQuotedCasing(Casing.UNCHANGED).setQuoting(Quoting.DOUBLE_QUOTE).setConformance((SqlConformance)DruidConformance.instance()).build();
    private final DruidSchema druidSchema;
    private final QueryLifecycleFactory queryLifecycleFactory;
    private final DruidOperatorTable operatorTable;
    private final ExprMacroTable macroTable;
    private final PlannerConfig plannerConfig;
    private final ObjectMapper jsonMapper;
    private final AuthConfig authConfig;
    private final AuthorizerMapper authorizerMapper;
    private final Escalator escalator;

    @Inject
    public PlannerFactory(DruidSchema druidSchema, QueryLifecycleFactory queryLifecycleFactory, DruidOperatorTable operatorTable, ExprMacroTable macroTable, PlannerConfig plannerConfig, AuthConfig authConfig, AuthorizerMapper authorizerMapper, Escalator escalator, @Json ObjectMapper jsonMapper) {
        this.druidSchema = druidSchema;
        this.queryLifecycleFactory = queryLifecycleFactory;
        this.operatorTable = operatorTable;
        this.macroTable = macroTable;
        this.plannerConfig = plannerConfig;
        this.authConfig = authConfig;
        this.authorizerMapper = authorizerMapper;
        this.escalator = escalator;
        this.jsonMapper = jsonMapper;
    }

    public DruidPlanner createPlanner(Map<String, Object> queryContext) {
        SchemaPlus rootSchema = Calcites.createRootSchema((Schema)this.druidSchema, this.authorizerMapper);
        PlannerContext plannerContext = PlannerContext.create(this.operatorTable, this.macroTable, this.plannerConfig, this.authorizerMapper, queryContext);
        QueryMaker queryMaker = new QueryMaker(this.queryLifecycleFactory, plannerContext, this.jsonMapper);
        SqlToRelConverter.Config sqlToRelConverterConfig = SqlToRelConverter.configBuilder().withExpand(false).withDecorrelationEnabled(false).withTrimUnusedFields(false).withInSubQueryThreshold(Integer.MAX_VALUE).build();
        FrameworkConfig frameworkConfig = Frameworks.newConfigBuilder().parserConfig(PARSER_CONFIG).traitDefs(new RelTraitDef[]{ConventionTraitDef.INSTANCE, RelCollationTraitDef.INSTANCE}).convertletTable((SqlRexConvertletTable)new DruidConvertletTable(plannerContext)).operatorTable((SqlOperatorTable)this.operatorTable).programs(Rules.programs(plannerContext, queryMaker)).executor((RexExecutor)new DruidRexExecutor(plannerContext)).context((Context)Contexts.EMPTY_CONTEXT).typeSystem((RelDataTypeSystem)DruidTypeSystem.INSTANCE).defaultSchema(rootSchema.getSubSchema("druid")).sqlToRelConverterConfig(sqlToRelConverterConfig).context(new Context(){

            public <C> C unwrap(Class<C> aClass) {
                if (aClass.equals(CalciteConnectionConfig.class)) {
                    Properties props = new Properties();
                    return (C)new CalciteConnectionConfigImpl(props){

                        public SqlConformance conformance() {
                            return DruidConformance.instance();
                        }
                    };
                }
                return null;
            }
        }).build();
        return new DruidPlanner(Frameworks.getPlanner((FrameworkConfig)frameworkConfig), plannerContext, this.authorizerMapper, this.escalator);
    }
}

