/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.planner;

import com.google.common.base.Supplier;
import io.druid.java.util.common.guava.Sequence;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.rel.type.RelDataType;

public class PlannerResult {
    private final Supplier<Sequence<Object[]>> resultsSupplier;
    private final RelDataType rowType;
    private final AtomicBoolean didRun = new AtomicBoolean();

    public PlannerResult(Supplier<Sequence<Object[]>> resultsSupplier, RelDataType rowType) {
        this.resultsSupplier = resultsSupplier;
        this.rowType = rowType;
    }

    public Sequence<Object[]> run() {
        if (!this.didRun.compareAndSet(false, true)) {
            throw new IllegalStateException("Cannot run more than once");
        }
        return (Sequence)this.resultsSupplier.get();
    }

    public RelDataType rowType() {
        return this.rowType;
    }
}

