/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.rel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.DataSource;
import io.druid.query.Query;
import io.druid.query.QueryDataSource;
import io.druid.query.TableDataSource;
import io.druid.sql.calcite.rel.DruidConvention;
import io.druid.sql.calcite.rel.DruidQuery;
import io.druid.sql.calcite.rel.DruidRel;
import io.druid.sql.calcite.rel.PartialDruidQuery;
import io.druid.sql.calcite.rel.QueryMaker;
import io.druid.sql.calcite.table.RowSignature;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;

public class DruidOuterQueryRel
extends DruidRel<DruidOuterQueryRel> {
    private static final TableDataSource DUMMY_DATA_SOURCE = new TableDataSource("__subquery__");
    private final PartialDruidQuery partialQuery;
    private RelNode sourceRel;

    private DruidOuterQueryRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode sourceRel, PartialDruidQuery partialQuery, QueryMaker queryMaker) {
        super(cluster, traitSet, queryMaker);
        this.sourceRel = sourceRel;
        this.partialQuery = partialQuery;
    }

    public static DruidOuterQueryRel create(DruidRel sourceRel, PartialDruidQuery partialQuery) {
        return new DruidOuterQueryRel(sourceRel.getCluster(), sourceRel.getTraitSet(), (RelNode)sourceRel, partialQuery, sourceRel.getQueryMaker());
    }

    @Override
    public PartialDruidQuery getPartialDruidQuery() {
        return this.partialQuery;
    }

    @Override
    public Sequence<Object[]> runQuery() {
        DruidQuery query = this.toDruidQuery(false);
        if (query != null) {
            return this.getQueryMaker().runQuery(query);
        }
        return Sequences.empty();
    }

    @Override
    public DruidOuterQueryRel withPartialQuery(PartialDruidQuery newQueryBuilder) {
        return new DruidOuterQueryRel(this.getCluster(), this.getTraitSet().plusAll(newQueryBuilder.getRelTraits()), this.sourceRel, newQueryBuilder, this.getQueryMaker());
    }

    @Override
    public int getQueryCount() {
        return 1 + ((DruidRel)this.sourceRel).getQueryCount();
    }

    @Override
    @Nullable
    public DruidQuery toDruidQuery(boolean finalizeAggregations) {
        DruidQuery subQuery = ((DruidRel)this.sourceRel).toDruidQuery(true);
        if (subQuery == null) {
            return null;
        }
        RowSignature sourceRowSignature = subQuery.getOutputRowSignature();
        return this.partialQuery.build((DataSource)new QueryDataSource((Query)subQuery.toGroupByQuery()), sourceRowSignature, this.getPlannerContext(), this.getCluster().getRexBuilder(), finalizeAggregations);
    }

    @Override
    public DruidQuery toDruidQueryForExplaining() {
        return this.partialQuery.build((DataSource)DUMMY_DATA_SOURCE, RowSignature.from(this.sourceRel.getRowType().getFieldNames(), this.sourceRel.getRowType()), this.getPlannerContext(), this.getCluster().getRexBuilder(), false);
    }

    @Override
    public DruidOuterQueryRel asBindable() {
        return new DruidOuterQueryRel(this.getCluster(), this.getTraitSet().plus((RelTrait)BindableConvention.INSTANCE), this.sourceRel, this.partialQuery, this.getQueryMaker());
    }

    @Override
    public DruidOuterQueryRel asDruidConvention() {
        return new DruidOuterQueryRel(this.getCluster(), this.getTraitSet().plus((RelTrait)DruidConvention.instance()), RelOptRule.convert((RelNode)this.sourceRel, (RelTrait)DruidConvention.instance()), this.partialQuery, this.getQueryMaker());
    }

    public List<RelNode> getInputs() {
        return ImmutableList.of((Object)this.sourceRel);
    }

    public void replaceInput(int ordinalInParent, RelNode p) {
        if (ordinalInParent != 0) {
            throw new IndexOutOfBoundsException(StringUtils.format((String)"Invalid ordinalInParent[%s]", (Object[])new Object[]{ordinalInParent}));
        }
        this.sourceRel = p;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DruidOuterQueryRel(this.getCluster(), traitSet, (RelNode)Iterables.getOnlyElement(inputs), this.getPartialDruidQuery(), this.getQueryMaker());
    }

    @Override
    public List<String> getDatasourceNames() {
        return ((DruidRel)this.sourceRel).getDatasourceNames();
    }

    public RelWriter explainTerms(RelWriter pw) {
        String queryString;
        DruidQuery druidQuery = this.toDruidQueryForExplaining();
        try {
            queryString = this.getQueryMaker().getJsonMapper().writeValueAsString((Object)druidQuery.getQuery());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return super.explainTerms(pw).input("innerQuery", this.sourceRel).item("query", (Object)queryString).item("signature", (Object)druidQuery.getOutputRowSignature());
    }

    protected RelDataType deriveRowType() {
        return this.partialQuery.getRowType();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeCost(mq.getRowCount(this.sourceRel).doubleValue(), 0.0, 0.0).multiplyBy(10.0);
    }
}

