/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.rel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.math.expr.ExprMacroTable;
import io.druid.math.expr.ExprType;
import io.druid.math.expr.Parser;
import io.druid.query.DataSource;
import io.druid.query.Query;
import io.druid.query.QueryDataSource;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.post.ExpressionPostAggregator;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.filter.DimFilter;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.having.DimFilterHavingSpec;
import io.druid.query.groupby.having.HavingSpec;
import io.druid.query.groupby.orderby.DefaultLimitSpec;
import io.druid.query.groupby.orderby.LimitSpec;
import io.druid.query.groupby.orderby.OrderByColumnSpec;
import io.druid.query.ordering.StringComparator;
import io.druid.query.ordering.StringComparators;
import io.druid.query.scan.ScanQuery;
import io.druid.query.select.PagingSpec;
import io.druid.query.select.SelectQuery;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.topn.DimensionTopNMetricSpec;
import io.druid.query.topn.InvertedTopNMetricSpec;
import io.druid.query.topn.NumericTopNMetricSpec;
import io.druid.query.topn.TopNMetricSpec;
import io.druid.query.topn.TopNQuery;
import io.druid.segment.VirtualColumn;
import io.druid.segment.VirtualColumns;
import io.druid.segment.column.ValueType;
import io.druid.sql.calcite.aggregation.Aggregation;
import io.druid.sql.calcite.aggregation.DimensionExpression;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.Expressions;
import io.druid.sql.calcite.filtration.Filtration;
import io.druid.sql.calcite.planner.Calcites;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.rel.CannotBuildQueryException;
import io.druid.sql.calcite.rel.Grouping;
import io.druid.sql.calcite.rel.PartialDruidQuery;
import io.druid.sql.calcite.rel.SelectProjection;
import io.druid.sql.calcite.rel.SortProject;
import io.druid.sql.calcite.rule.GroupByRules;
import io.druid.sql.calcite.table.RowSignature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;

public class DruidQuery {
    private final DataSource dataSource;
    private final RowSignature sourceRowSignature;
    private final PlannerContext plannerContext;
    private final DimFilter filter;
    private final SelectProjection selectProjection;
    private final Grouping grouping;
    private final SortProject sortProject;
    private final DefaultLimitSpec limitSpec;
    private final RowSignature outputRowSignature;
    private final RelDataType outputRowType;
    private final Query query;

    public DruidQuery(PartialDruidQuery partialQuery, DataSource dataSource, RowSignature sourceRowSignature, PlannerContext plannerContext, RexBuilder rexBuilder, boolean finalizeAggregations) {
        this.dataSource = dataSource;
        this.sourceRowSignature = sourceRowSignature;
        this.outputRowType = partialQuery.leafRel().getRowType();
        this.plannerContext = plannerContext;
        this.filter = DruidQuery.computeWhereFilter(partialQuery, sourceRowSignature, plannerContext);
        this.selectProjection = DruidQuery.computeSelectProjection(partialQuery, plannerContext, sourceRowSignature);
        this.grouping = DruidQuery.computeGrouping(partialQuery, plannerContext, sourceRowSignature, rexBuilder, finalizeAggregations);
        RowSignature sortingInputRowSignature = this.selectProjection != null ? this.selectProjection.getOutputRowSignature() : (this.grouping != null ? this.grouping.getOutputRowSignature() : sourceRowSignature);
        this.sortProject = this.computeSortProject(partialQuery, plannerContext, sortingInputRowSignature, this.grouping);
        this.outputRowSignature = this.sortProject == null ? sortingInputRowSignature : this.sortProject.getOutputRowSignature();
        this.limitSpec = DruidQuery.computeLimitSpec(partialQuery, sortingInputRowSignature);
        this.query = this.computeQuery();
    }

    @Nullable
    private static DimFilter computeWhereFilter(PartialDruidQuery partialQuery, RowSignature sourceRowSignature, PlannerContext plannerContext) {
        Filter whereFilter = partialQuery.getWhereFilter();
        if (whereFilter == null) {
            return null;
        }
        RexNode condition = whereFilter.getCondition();
        DimFilter dimFilter = Expressions.toFilter(plannerContext, sourceRowSignature, condition);
        if (dimFilter == null) {
            throw new CannotBuildQueryException((RelNode)whereFilter, condition);
        }
        return dimFilter;
    }

    @Nullable
    private static SelectProjection computeSelectProjection(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature sourceRowSignature) {
        Project project = partialQuery.getSelectProject();
        if (project == null || partialQuery.getAggregate() != null) {
            return null;
        }
        ArrayList<DruidExpression> expressions = new ArrayList<DruidExpression>();
        for (RexNode rexNode : project.getChildExps()) {
            DruidExpression expression = Expressions.toDruidExpression(plannerContext, sourceRowSignature, rexNode);
            if (expression == null) {
                throw new CannotBuildQueryException((RelNode)project, rexNode);
            }
            expressions.add(expression);
        }
        ArrayList<String> directColumns = new ArrayList<String>();
        ArrayList<VirtualColumn> virtualColumns = new ArrayList<VirtualColumn>();
        ArrayList<String> rowOrder = new ArrayList<String>();
        String virtualColumnPrefix = Calcites.findUnusedPrefix("v", new TreeSet<String>(sourceRowSignature.getRowOrder()));
        int virtualColumnNameCounter = 0;
        for (int i = 0; i < expressions.size(); ++i) {
            DruidExpression expression = (DruidExpression)expressions.get(i);
            if (expression.isDirectColumnAccess()) {
                directColumns.add(expression.getDirectColumn());
                rowOrder.add(expression.getDirectColumn());
                continue;
            }
            String virtualColumnName = virtualColumnPrefix + virtualColumnNameCounter++;
            virtualColumns.add((VirtualColumn)expression.toVirtualColumn(virtualColumnName, Calcites.getValueTypeForSqlTypeName(((RexNode)project.getChildExps().get(i)).getType().getSqlTypeName()), plannerContext.getExprMacroTable()));
            rowOrder.add(virtualColumnName);
        }
        return new SelectProjection(directColumns, virtualColumns, RowSignature.from(rowOrder, project.getRowType()));
    }

    @Nullable
    private static Grouping computeGrouping(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature sourceRowSignature, RexBuilder rexBuilder, boolean finalizeAggregations) {
        Aggregate aggregate = partialQuery.getAggregate();
        Project aggregateProject = partialQuery.getAggregateProject();
        if (aggregate == null) {
            return null;
        }
        List<DimensionExpression> dimensions = DruidQuery.computeDimensions(partialQuery, plannerContext, sourceRowSignature);
        List<Aggregation> aggregations = DruidQuery.computeAggregations(partialQuery, plannerContext, sourceRowSignature, rexBuilder, finalizeAggregations);
        RowSignature aggregateRowSignature = RowSignature.from((List<String>)ImmutableList.copyOf((Iterator)Iterators.concat(dimensions.stream().map(DimensionExpression::getOutputName).iterator(), aggregations.stream().map(Aggregation::getOutputName).iterator())), aggregate.getRowType());
        DimFilter havingFilter = DruidQuery.computeHavingFilter(partialQuery, aggregateRowSignature, plannerContext);
        if (aggregateProject == null) {
            return Grouping.create(dimensions, aggregations, havingFilter, aggregateRowSignature);
        }
        ProjectRowOrderAndPostAggregations projectRowOrderAndPostAggregations = DruidQuery.computePostAggregations(plannerContext, aggregateRowSignature, aggregateProject, "p");
        projectRowOrderAndPostAggregations.postAggregations.forEach(postAggregator -> aggregations.add(Aggregation.create(postAggregator)));
        ImmutableBitSet aggregateProjectBits = RelOptUtil.InputFinder.bits((List)aggregateProject.getChildExps(), null);
        for (int i = dimensions.size() - 1; i >= 0; --i) {
            DimensionExpression dimension = dimensions.get(i);
            if (!Parser.parse((String)dimension.getDruidExpression().getExpression(), (ExprMacroTable)plannerContext.getExprMacroTable()).isLiteral() || aggregateProjectBits.get(i)) continue;
            dimensions.remove(i);
        }
        return Grouping.create(dimensions, aggregations, havingFilter, RowSignature.from(projectRowOrderAndPostAggregations.rowOrder, aggregateProject.getRowType()));
    }

    @Nullable
    private SortProject computeSortProject(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature sortingInputRowSignature, Grouping grouping) {
        Project sortProject = partialQuery.getSortProject();
        if (sortProject == null) {
            return null;
        }
        ProjectRowOrderAndPostAggregations projectRowOrderAndPostAggregations = DruidQuery.computePostAggregations(plannerContext, sortingInputRowSignature, sortProject, "s");
        return new SortProject(sortingInputRowSignature, projectRowOrderAndPostAggregations.postAggregations, RowSignature.from(projectRowOrderAndPostAggregations.rowOrder, sortProject.getRowType()));
    }

    private static ProjectRowOrderAndPostAggregations computePostAggregations(PlannerContext plannerContext, RowSignature inputRowSignature, Project project, String basePrefix) {
        ArrayList<String> rowOrder = new ArrayList<String>();
        ArrayList<PostAggregator> aggregations = new ArrayList<PostAggregator>();
        String outputNamePrefix = Calcites.findUnusedPrefix(basePrefix, new TreeSet<String>(inputRowSignature.getRowOrder()));
        int outputNameCounter = 0;
        for (RexNode postAggregatorRexNode : project.getChildExps()) {
            DruidExpression postAggregatorExpression = Expressions.toDruidExpression(plannerContext, inputRowSignature, postAggregatorRexNode);
            if (postAggregatorExpression == null) {
                throw new CannotBuildQueryException((RelNode)project, postAggregatorRexNode);
            }
            if (DruidQuery.postAggregatorDirectColumnIsOk(inputRowSignature, postAggregatorExpression, postAggregatorRexNode)) {
                rowOrder.add(postAggregatorExpression.getDirectColumn());
                continue;
            }
            String postAggregatorName = outputNamePrefix + outputNameCounter++;
            ExpressionPostAggregator postAggregator = new ExpressionPostAggregator(postAggregatorName, postAggregatorExpression.getExpression(), null, plannerContext.getExprMacroTable());
            aggregations.add((PostAggregator)postAggregator);
            rowOrder.add(postAggregator.getName());
        }
        return new ProjectRowOrderAndPostAggregations(rowOrder, aggregations);
    }

    private static List<DimensionExpression> computeDimensions(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature sourceRowSignature) {
        Aggregate aggregate = (Aggregate)Preconditions.checkNotNull((Object)partialQuery.getAggregate());
        ArrayList<DimensionExpression> dimensions = new ArrayList<DimensionExpression>();
        String outputNamePrefix = Calcites.findUnusedPrefix("d", new TreeSet<String>(sourceRowSignature.getRowOrder()));
        int outputNameCounter = 0;
        Iterator iterator = aggregate.getGroupSet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            String dimOutputName = outputNamePrefix + outputNameCounter++;
            RexNode rexNode = Expressions.fromFieldAccess(sourceRowSignature, partialQuery.getSelectProject(), i);
            DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, sourceRowSignature, rexNode);
            if (druidExpression == null) {
                throw new CannotBuildQueryException((RelNode)aggregate, rexNode);
            }
            SqlTypeName sqlTypeName = rexNode.getType().getSqlTypeName();
            ValueType outputType = Calcites.getValueTypeForSqlTypeName(sqlTypeName);
            if (outputType == null || outputType == ValueType.COMPLEX) {
                throw new CannotBuildQueryException((RelNode)aggregate, rexNode);
            }
            dimensions.add(new DimensionExpression(dimOutputName, druidExpression, outputType));
        }
        return dimensions;
    }

    private static List<Aggregation> computeAggregations(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature sourceRowSignature, RexBuilder rexBuilder, boolean finalizeAggregations) {
        Aggregate aggregate = (Aggregate)Preconditions.checkNotNull((Object)partialQuery.getAggregate());
        ArrayList<Aggregation> aggregations = new ArrayList<Aggregation>();
        String outputNamePrefix = Calcites.findUnusedPrefix("a", new TreeSet<String>(sourceRowSignature.getRowOrder()));
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            String aggName = outputNamePrefix + i;
            AggregateCall aggCall = (AggregateCall)aggregate.getAggCallList().get(i);
            Aggregation aggregation = GroupByRules.translateAggregateCall(plannerContext, sourceRowSignature, rexBuilder, partialQuery.getSelectProject(), aggCall, aggregations, aggName, finalizeAggregations);
            if (aggregation == null) {
                throw new CannotBuildQueryException((RelNode)aggregate, aggCall);
            }
            aggregations.add(aggregation);
        }
        return aggregations;
    }

    @Nullable
    private static DimFilter computeHavingFilter(PartialDruidQuery partialQuery, RowSignature outputRowSignature, PlannerContext plannerContext) {
        Filter havingFilter = partialQuery.getHavingFilter();
        if (havingFilter == null) {
            return null;
        }
        RexNode condition = havingFilter.getCondition();
        DimFilter dimFilter = Expressions.toFilter(plannerContext, outputRowSignature, condition);
        if (dimFilter == null) {
            throw new CannotBuildQueryException((RelNode)havingFilter, condition);
        }
        return dimFilter;
    }

    @Nullable
    private static DefaultLimitSpec computeLimitSpec(PartialDruidQuery partialQuery, RowSignature outputRowSignature) {
        Sort sort = partialQuery.getAggregate() == null ? partialQuery.getSelectSort() : partialQuery.getSort();
        if (sort == null) {
            return null;
        }
        Integer limit = sort.fetch != null ? Integer.valueOf(RexLiteral.intValue((RexNode)sort.fetch)) : null;
        ArrayList<OrderByColumnSpec> orderBys = new ArrayList<OrderByColumnSpec>(sort.getChildExps().size());
        if (sort.offset != null) {
            throw new CannotBuildQueryException((RelNode)sort);
        }
        for (int sortKey = 0; sortKey < sort.getChildExps().size(); ++sortKey) {
            OrderByColumnSpec.Direction direction;
            RexNode sortExpression = (RexNode)sort.getChildExps().get(sortKey);
            RelFieldCollation collation = (RelFieldCollation)sort.getCollation().getFieldCollations().get(sortKey);
            if (collation.getDirection() == RelFieldCollation.Direction.ASCENDING) {
                direction = OrderByColumnSpec.Direction.ASCENDING;
            } else if (collation.getDirection() == RelFieldCollation.Direction.DESCENDING) {
                direction = OrderByColumnSpec.Direction.DESCENDING;
            } else {
                throw new ISE("WTF?! Don't know what to do with direction[%s]", new Object[]{collation.getDirection()});
            }
            SqlTypeName sortExpressionType = sortExpression.getType().getSqlTypeName();
            StringComparator comparator = SqlTypeName.NUMERIC_TYPES.contains(sortExpressionType) || SqlTypeName.TIMESTAMP == sortExpressionType || SqlTypeName.DATE == sortExpressionType ? StringComparators.NUMERIC : StringComparators.LEXICOGRAPHIC;
            if (!sortExpression.isA(SqlKind.INPUT_REF)) {
                throw new CannotBuildQueryException((RelNode)sort, sortExpression);
            }
            RexInputRef ref = (RexInputRef)sortExpression;
            String fieldName = outputRowSignature.getRowOrder().get(ref.getIndex());
            orderBys.add(new OrderByColumnSpec(fieldName, direction, comparator));
        }
        return new DefaultLimitSpec(orderBys, limit);
    }

    private static boolean postAggregatorDirectColumnIsOk(RowSignature aggregateRowSignature, DruidExpression expression, RexNode rexNode) {
        if (!expression.isDirectColumnAccess()) {
            return false;
        }
        ExprType toExprType = Expressions.exprTypeForValueType(aggregateRowSignature.getColumnType(expression.getDirectColumn()));
        ExprType fromExprType = Expressions.exprTypeForValueType(Calcites.getValueTypeForSqlTypeName(rexNode.getType().getSqlTypeName()));
        return toExprType.equals((Object)fromExprType);
    }

    public VirtualColumns getVirtualColumns(ExprMacroTable macroTable, boolean includeDimensions) {
        ArrayList<VirtualColumn> retVal = new ArrayList<VirtualColumn>();
        if (this.selectProjection != null) {
            retVal.addAll(this.selectProjection.getVirtualColumns());
        } else if (this.grouping != null) {
            if (includeDimensions) {
                for (DimensionExpression dimensionExpression : this.grouping.getDimensions()) {
                    retVal.addAll(dimensionExpression.getVirtualColumns(macroTable));
                }
            }
            for (Aggregation aggregation : this.grouping.getAggregations()) {
                retVal.addAll(aggregation.getVirtualColumns());
            }
        }
        return VirtualColumns.create(retVal);
    }

    public Grouping getGrouping() {
        return this.grouping;
    }

    public DefaultLimitSpec getLimitSpec() {
        return this.limitSpec;
    }

    public SortProject getSortProject() {
        return this.sortProject;
    }

    public RelDataType getOutputRowType() {
        return this.outputRowType;
    }

    public RowSignature getSourceRowSignature() {
        return this.sourceRowSignature;
    }

    public RowSignature getOutputRowSignature() {
        return this.outputRowSignature;
    }

    public Query getQuery() {
        return this.query;
    }

    private Query computeQuery() {
        if (this.dataSource instanceof QueryDataSource) {
            GroupByQuery outerQuery = this.toGroupByQuery();
            if (outerQuery == null) {
                throw new IllegalStateException("Can't use QueryDataSource without an outer groupBy query!");
            }
            return outerQuery;
        }
        TimeseriesQuery tsQuery = this.toTimeseriesQuery();
        if (tsQuery != null) {
            return tsQuery;
        }
        TopNQuery topNQuery = this.toTopNQuery();
        if (topNQuery != null) {
            return topNQuery;
        }
        GroupByQuery groupByQuery = this.toGroupByQuery();
        if (groupByQuery != null) {
            return groupByQuery;
        }
        ScanQuery scanQuery = this.toScanQuery();
        if (scanQuery != null) {
            return scanQuery;
        }
        SelectQuery selectQuery = this.toSelectQuery();
        if (selectQuery != null) {
            return selectQuery;
        }
        throw new CannotBuildQueryException("Cannot convert query parts into an actual query");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public TimeseriesQuery toTimeseriesQuery() {
        boolean descending;
        Granularity queryGranularity;
        if (this.grouping == null || this.grouping.getHavingFilter() != null) {
            return null;
        }
        if (this.grouping.getDimensions().isEmpty()) {
            queryGranularity = Granularities.ALL;
            descending = false;
        } else {
            if (this.grouping.getDimensions().size() != 1) return null;
            DimensionExpression dimensionExpression = (DimensionExpression)Iterables.getOnlyElement(this.grouping.getDimensions());
            queryGranularity = Expressions.toQueryGranularity(dimensionExpression.getDruidExpression(), this.plannerContext.getExprMacroTable());
            if (queryGranularity == null) {
                return null;
            }
            if (this.limitSpec != null) {
                if (this.limitSpec.isLimited()) {
                    return null;
                }
                if (this.limitSpec.getColumns().isEmpty()) {
                    descending = false;
                } else {
                    OrderByColumnSpec firstOrderBy = (OrderByColumnSpec)this.limitSpec.getColumns().get(0);
                    if (!firstOrderBy.getDimension().equals(dimensionExpression.getOutputName())) return null;
                    descending = firstOrderBy.getDirection() == OrderByColumnSpec.Direction.DESCENDING;
                }
            } else {
                descending = false;
            }
        }
        Filtration filtration = Filtration.create(this.filter).optimize(this.sourceRowSignature);
        ArrayList<PostAggregator> postAggregators = new ArrayList<PostAggregator>(this.grouping.getPostAggregators());
        if (this.sortProject != null) {
            postAggregators.addAll(this.sortProject.getPostAggregators());
        }
        HashMap theContext = Maps.newHashMap();
        theContext.put("skipEmptyBuckets", true);
        theContext.putAll(this.plannerContext.getQueryContext());
        return new TimeseriesQuery(this.dataSource, filtration.getQuerySegmentSpec(), descending, this.getVirtualColumns(this.plannerContext.getExprMacroTable(), false), filtration.getDimFilter(), queryGranularity, this.grouping.getAggregatorFactories(), postAggregators, (Map)ImmutableSortedMap.copyOf((Map)theContext));
    }

    @Nullable
    public TopNQuery toTopNQuery() {
        DimensionTopNMetricSpec topNMetricSpec;
        DimensionTopNMetricSpec baseMetricSpec;
        boolean topNOk;
        boolean bl = topNOk = this.grouping != null && this.grouping.getDimensions().size() == 1 && this.limitSpec != null && this.limitSpec.getColumns().size() <= 1 && this.limitSpec.getLimit() <= this.plannerContext.getPlannerConfig().getMaxTopNLimit() && this.grouping.getHavingFilter() == null;
        if (!topNOk) {
            return null;
        }
        DimensionSpec dimensionSpec = ((DimensionExpression)Iterables.getOnlyElement(this.grouping.getDimensions())).toDimensionSpec();
        OrderByColumnSpec limitColumn = this.limitSpec.getColumns().isEmpty() ? new OrderByColumnSpec(dimensionSpec.getOutputName(), OrderByColumnSpec.Direction.ASCENDING, Calcites.getStringComparatorForValueType(dimensionSpec.getOutputType())) : (OrderByColumnSpec)Iterables.getOnlyElement((Iterable)this.limitSpec.getColumns());
        if (limitColumn.getDimension().equals(dimensionSpec.getOutputName())) {
            baseMetricSpec = new DimensionTopNMetricSpec(null, limitColumn.getDimensionComparator());
            topNMetricSpec = limitColumn.getDirection() == OrderByColumnSpec.Direction.ASCENDING ? baseMetricSpec : new InvertedTopNMetricSpec((TopNMetricSpec)baseMetricSpec);
        } else if (this.plannerContext.getPlannerConfig().isUseApproximateTopN()) {
            baseMetricSpec = new NumericTopNMetricSpec(limitColumn.getDimension());
            topNMetricSpec = limitColumn.getDirection() == OrderByColumnSpec.Direction.ASCENDING ? new InvertedTopNMetricSpec((TopNMetricSpec)baseMetricSpec) : baseMetricSpec;
        } else {
            return null;
        }
        Filtration filtration = Filtration.create(this.filter).optimize(this.sourceRowSignature);
        ArrayList<PostAggregator> postAggregators = new ArrayList<PostAggregator>(this.grouping.getPostAggregators());
        if (this.sortProject != null) {
            postAggregators.addAll(this.sortProject.getPostAggregators());
        }
        return new TopNQuery(this.dataSource, this.getVirtualColumns(this.plannerContext.getExprMacroTable(), true), dimensionSpec, (TopNMetricSpec)topNMetricSpec, this.limitSpec.getLimit(), filtration.getQuerySegmentSpec(), filtration.getDimFilter(), Granularities.ALL, this.grouping.getAggregatorFactories(), postAggregators, (Map)ImmutableSortedMap.copyOf(this.plannerContext.getQueryContext()));
    }

    @Nullable
    public GroupByQuery toGroupByQuery() {
        if (this.grouping == null) {
            return null;
        }
        Filtration filtration = Filtration.create(this.filter).optimize(this.sourceRowSignature);
        ArrayList<PostAggregator> postAggregators = new ArrayList<PostAggregator>(this.grouping.getPostAggregators());
        if (this.sortProject != null) {
            postAggregators.addAll(this.sortProject.getPostAggregators());
        }
        return new GroupByQuery(this.dataSource, filtration.getQuerySegmentSpec(), this.getVirtualColumns(this.plannerContext.getExprMacroTable(), true), filtration.getDimFilter(), Granularities.ALL, this.grouping.getDimensionSpecs(), this.grouping.getAggregatorFactories(), postAggregators, (HavingSpec)(this.grouping.getHavingFilter() != null ? new DimFilterHavingSpec(this.grouping.getHavingFilter(), Boolean.valueOf(true)) : null), (LimitSpec)this.limitSpec, (Map)ImmutableSortedMap.copyOf(this.plannerContext.getQueryContext()));
    }

    @Nullable
    public ScanQuery toScanQuery() {
        if (this.grouping != null) {
            return null;
        }
        if (this.limitSpec != null && this.limitSpec.getColumns().size() > 0) {
            return null;
        }
        if (this.outputRowSignature.getRowOrder().isEmpty()) {
            throw new ISE("WTF?! Attempting to convert to Scan query without any columns?", new Object[0]);
        }
        Filtration filtration = Filtration.create(this.filter).optimize(this.sourceRowSignature);
        long scanLimit = this.limitSpec == null || this.limitSpec.getLimit() == Integer.MAX_VALUE ? 0L : (long)this.limitSpec.getLimit();
        return new ScanQuery(this.dataSource, filtration.getQuerySegmentSpec(), this.selectProjection != null ? VirtualColumns.create(this.selectProjection.getVirtualColumns()) : VirtualColumns.EMPTY, "compactedList", 0, scanLimit, filtration.getDimFilter(), Ordering.natural().sortedCopy((Iterable)ImmutableSet.copyOf(this.outputRowSignature.getRowOrder())), Boolean.valueOf(false), (Map)ImmutableSortedMap.copyOf(this.plannerContext.getQueryContext()));
    }

    @Nullable
    public SelectQuery toSelectQuery() {
        int threshold;
        boolean descending;
        if (this.grouping != null) {
            return null;
        }
        Filtration filtration = Filtration.create(this.filter).optimize(this.sourceRowSignature);
        if (this.limitSpec != null) {
            if (this.limitSpec.getColumns().size() == 0) {
                descending = false;
            } else if (this.limitSpec.getColumns().size() == 1) {
                OrderByColumnSpec orderBy = (OrderByColumnSpec)Iterables.getOnlyElement((Iterable)this.limitSpec.getColumns());
                if (!orderBy.getDimension().equals("__time")) {
                    return null;
                }
                descending = orderBy.getDirection() == OrderByColumnSpec.Direction.DESCENDING;
            } else {
                return null;
            }
            threshold = this.limitSpec.getLimit();
        } else {
            descending = false;
            threshold = 0;
        }
        String dummyColumn = "dummy";
        while (this.sourceRowSignature.getColumnType(dummyColumn) != null || this.outputRowSignature.getRowOrder().contains(dummyColumn)) {
            dummyColumn = dummyColumn + "_";
        }
        ArrayList<String> metrics = new ArrayList<String>();
        if (this.selectProjection != null) {
            metrics.addAll(this.selectProjection.getDirectColumns());
            metrics.addAll(this.selectProjection.getVirtualColumns().stream().map(VirtualColumn::getOutputName).collect(Collectors.toList()));
        } else {
            metrics.addAll(this.outputRowSignature.getRowOrder());
        }
        if (metrics.isEmpty()) {
            metrics.add(dummyColumn);
        }
        PagingSpec pagingSpec = new PagingSpec(null, threshold);
        return new SelectQuery(this.dataSource, filtration.getQuerySegmentSpec(), descending, filtration.getDimFilter(), Granularities.ALL, (List)ImmutableList.of((Object)new DefaultDimensionSpec(dummyColumn, dummyColumn)), metrics.stream().sorted().distinct().collect(Collectors.toList()), this.getVirtualColumns(this.plannerContext.getExprMacroTable(), true), pagingSpec, (Map)ImmutableSortedMap.copyOf(this.plannerContext.getQueryContext()));
    }

    private static class ProjectRowOrderAndPostAggregations {
        private final List<String> rowOrder;
        private final List<PostAggregator> postAggregations;

        ProjectRowOrderAndPostAggregations(List<String> rowOrder, List<PostAggregator> postAggregations) {
            this.rowOrder = rowOrder;
            this.postAggregations = postAggregations;
        }
    }
}

