/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.rel;

import com.google.common.base.Throwables;
import io.druid.java.util.common.guava.Accumulator;
import io.druid.java.util.common.guava.Sequence;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.rel.CannotBuildQueryException;
import io.druid.sql.calcite.rel.DruidQuery;
import io.druid.sql.calcite.rel.PartialDruidQuery;
import io.druid.sql.calcite.rel.QueryMaker;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.BindableRel;
import org.apache.calcite.interpreter.InterpretableRel;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;

public abstract class DruidRel<T extends DruidRel>
extends AbstractRelNode
implements BindableRel {
    private final QueryMaker queryMaker;

    protected DruidRel(RelOptCluster cluster, RelTraitSet traitSet, QueryMaker queryMaker) {
        super(cluster, traitSet);
        this.queryMaker = queryMaker;
    }

    public abstract PartialDruidQuery getPartialDruidQuery();

    public abstract int getQueryCount();

    public abstract Sequence<Object[]> runQuery();

    public abstract T withPartialQuery(PartialDruidQuery var1);

    public boolean isValidDruidQuery() {
        try {
            this.toDruidQueryForExplaining();
            return true;
        }
        catch (CannotBuildQueryException e) {
            return false;
        }
    }

    @Nullable
    public abstract DruidQuery toDruidQuery(boolean var1);

    public abstract DruidQuery toDruidQueryForExplaining();

    public abstract T asBindable();

    public QueryMaker getQueryMaker() {
        return this.queryMaker;
    }

    public PlannerContext getPlannerContext() {
        return this.queryMaker.getPlannerContext();
    }

    public abstract T asDruidConvention();

    public abstract List<String> getDatasourceNames();

    public Class<Object[]> getElementType() {
        return Object[].class;
    }

    public Node implement(InterpretableRel.InterpreterImplementor implementor) {
        final Sink sink = implementor.interpreter.sink((RelNode)this);
        return new Node(){

            public void run() throws InterruptedException {
                DruidRel.this.runQuery().accumulate((Object)sink, (Accumulator)new Accumulator<Sink, Object[]>(){

                    public Sink accumulate(Sink theSink, Object[] in) {
                        try {
                            theSink.send(Row.of((Object[])in));
                        }
                        catch (InterruptedException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                        return theSink;
                    }
                });
            }
        };
    }

    public Enumerable<Object[]> bind(DataContext dataContext) {
        throw new UnsupportedOperationException();
    }
}

