/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.rel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.guava.Accumulator;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.ResourceLimitExceededException;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.rel.DruidConvention;
import io.druid.sql.calcite.rel.DruidQuery;
import io.druid.sql.calcite.rel.DruidRel;
import io.druid.sql.calcite.rel.PartialDruidQuery;
import io.druid.sql.calcite.rel.QueryMaker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class DruidSemiJoin
extends DruidRel<DruidSemiJoin> {
    private final List<RexNode> leftExpressions;
    private final List<Integer> rightKeys;
    private final int maxSemiJoinRowsInMemory;
    private DruidRel<?> left;
    private RelNode right;

    private DruidSemiJoin(RelOptCluster cluster, RelTraitSet traitSet, DruidRel<?> left, RelNode right, List<RexNode> leftExpressions, List<Integer> rightKeys, int maxSemiJoinRowsInMemory, QueryMaker queryMaker) {
        super(cluster, traitSet, queryMaker);
        this.left = left;
        this.right = right;
        this.leftExpressions = ImmutableList.copyOf(leftExpressions);
        this.rightKeys = ImmutableList.copyOf(rightKeys);
        this.maxSemiJoinRowsInMemory = maxSemiJoinRowsInMemory;
    }

    public static DruidSemiJoin create(DruidRel left, DruidRel right, List<Integer> leftKeys, List<Integer> rightKeys, PlannerContext plannerContext) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        PartialDruidQuery leftPartialQuery = left.getPartialDruidQuery();
        if (leftPartialQuery.stage().compareTo(PartialDruidQuery.Stage.AGGREGATE) >= 0) {
            throw new ISE("LHS must not be an Aggregate", new Object[0]);
        }
        if (leftPartialQuery.getSelectProject() != null) {
            for (int key : leftKeys) {
                listBuilder.add(leftPartialQuery.getSelectProject().getChildExps().get(key));
            }
        } else {
            for (int key : leftKeys) {
                listBuilder.add((Object)RexInputRef.of((int)key, (RelDataType)leftPartialQuery.getRowType()));
            }
        }
        return new DruidSemiJoin(left.getCluster(), left.getTraitSet(), left, (RelNode)right, (List<RexNode>)listBuilder.build(), rightKeys, plannerContext.getPlannerConfig().getMaxSemiJoinRowsInMemory(), left.getQueryMaker());
    }

    @Override
    public PartialDruidQuery getPartialDruidQuery() {
        return this.left.getPartialDruidQuery();
    }

    @Override
    public DruidSemiJoin withPartialQuery(PartialDruidQuery newQueryBuilder) {
        return new DruidSemiJoin(this.getCluster(), this.getTraitSet().plusAll(newQueryBuilder.getRelTraits()), (DruidRel<?>)((Object)this.left.withPartialQuery(newQueryBuilder)), this.right, this.leftExpressions, this.rightKeys, this.maxSemiJoinRowsInMemory, this.getQueryMaker());
    }

    @Override
    @Nullable
    public DruidQuery toDruidQuery(boolean finalizeAggregations) {
        DruidRel<?> rel = this.getLeftRelWithFilter();
        return rel != null ? rel.toDruidQuery(finalizeAggregations) : null;
    }

    @Override
    public DruidQuery toDruidQueryForExplaining() {
        return this.left.toDruidQueryForExplaining();
    }

    @Override
    public DruidSemiJoin asBindable() {
        return new DruidSemiJoin(this.getCluster(), this.getTraitSet().replace((RelTrait)BindableConvention.INSTANCE), this.left, RelOptRule.convert((RelNode)this.right, (RelTrait)BindableConvention.INSTANCE), this.leftExpressions, this.rightKeys, this.maxSemiJoinRowsInMemory, this.getQueryMaker());
    }

    @Override
    public DruidSemiJoin asDruidConvention() {
        return new DruidSemiJoin(this.getCluster(), this.getTraitSet().replace((RelTrait)DruidConvention.instance()), this.left, RelOptRule.convert((RelNode)this.right, (RelTrait)DruidConvention.instance()), this.leftExpressions, this.rightKeys, this.maxSemiJoinRowsInMemory, this.getQueryMaker());
    }

    @Override
    public List<String> getDatasourceNames() {
        DruidRel druidRight = (DruidRel)this.right;
        LinkedHashSet<String> datasourceNames = new LinkedHashSet<String>();
        datasourceNames.addAll(this.left.getDatasourceNames());
        datasourceNames.addAll(druidRight.getDatasourceNames());
        return new ArrayList<String>(datasourceNames);
    }

    @Override
    public int getQueryCount() {
        return this.left.getQueryCount() + ((DruidRel)this.right).getQueryCount();
    }

    @Override
    public Sequence<Object[]> runQuery() {
        DruidRel<?> rel = this.getLeftRelWithFilter();
        if (rel != null) {
            return rel.runQuery();
        }
        return Sequences.empty();
    }

    protected RelDataType deriveRowType() {
        return this.left.getRowType();
    }

    public List<RelNode> getInputs() {
        return ImmutableList.of((Object)this.right);
    }

    public void replaceInput(int ordinalInParent, RelNode p) {
        if (ordinalInParent != 0) {
            throw new IndexOutOfBoundsException(StringUtils.format((String)"Invalid ordinalInParent[%s]", (Object[])new Object[]{ordinalInParent}));
        }
        this.right = p;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DruidSemiJoin(this.getCluster(), this.getTraitSet(), this.left, (RelNode)Iterables.getOnlyElement(inputs), this.leftExpressions, this.rightKeys, this.maxSemiJoinRowsInMemory, this.getQueryMaker());
    }

    public RelWriter explainTerms(RelWriter pw) {
        String queryString;
        try {
            queryString = this.getQueryMaker().getJsonMapper().writeValueAsString((Object)this.toDruidQueryForExplaining().getQuery());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return super.explainTerms(pw).input("right", this.right).item("query", (Object)queryString).item("leftExpressions", this.leftExpressions).item("rightKeys", this.rightKeys);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return this.right.computeSelfCost(planner, mq).plus(this.left.computeSelfCost(planner, mq).multiplyBy(50.0));
    }

    private DruidRel<?> getLeftRelWithFilter() {
        DruidRel druidRight = (DruidRel)this.right;
        final HashSet valuess = new HashSet();
        List conditions = (List)druidRight.runQuery().accumulate(new ArrayList(), (Accumulator)new Accumulator<List<RexNode>, Object[]>(){

            public List<RexNode> accumulate(List<RexNode> theConditions, Object[] row) {
                Object value;
                int i;
                ArrayList<String> values = new ArrayList<String>(DruidSemiJoin.this.rightKeys.size());
                Iterator iterator = DruidSemiJoin.this.rightKeys.iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    value = row[i];
                    String stringValue = value != null ? String.valueOf(value) : "";
                    values.add(stringValue);
                    if (values.size() <= DruidSemiJoin.this.maxSemiJoinRowsInMemory) continue;
                    throw new ResourceLimitExceededException(StringUtils.format((String)"maxSemiJoinRowsInMemory[%,d] exceeded", (Object[])new Object[]{DruidSemiJoin.this.maxSemiJoinRowsInMemory}), new Object[0]);
                }
                if (valuess.add(values)) {
                    ArrayList<RexNode> subConditions = new ArrayList<RexNode>();
                    for (i = 0; i < values.size(); ++i) {
                        value = (String)values.get(i);
                        subConditions.add(DruidSemiJoin.this.getCluster().getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{(RexNode)DruidSemiJoin.this.leftExpressions.get(i), DruidSemiJoin.this.getCluster().getRexBuilder().makeLiteral((String)value)}));
                    }
                    theConditions.add(DruidSemiJoin.this.makeAnd(subConditions));
                }
                return theConditions;
            }
        });
        valuess.clear();
        if (!conditions.isEmpty()) {
            PartialDruidQuery leftPartialQuery = this.left.getPartialDruidQuery();
            Filter whereFilter = leftPartialQuery.getWhereFilter();
            Object newWhereFilter = whereFilter != null ? whereFilter.copy(whereFilter.getTraitSet(), whereFilter.getInput(), this.makeAnd((List<RexNode>)ImmutableList.of((Object)whereFilter.getCondition(), (Object)this.makeOr(conditions)))) : LogicalFilter.create((RelNode)leftPartialQuery.getScan(), (RexNode)this.makeOr(conditions));
            PartialDruidQuery newPartialQuery = PartialDruidQuery.create(leftPartialQuery.getScan()).withWhereFilter((Filter)newWhereFilter).withSelectProject(leftPartialQuery.getSelectProject()).withSelectSort(leftPartialQuery.getSelectSort());
            if (leftPartialQuery.getAggregate() != null) {
                newPartialQuery = newPartialQuery.withAggregate(leftPartialQuery.getAggregate());
            }
            if (leftPartialQuery.getHavingFilter() != null) {
                newPartialQuery = newPartialQuery.withHavingFilter(leftPartialQuery.getHavingFilter());
            }
            if (leftPartialQuery.getAggregateProject() != null) {
                newPartialQuery = newPartialQuery.withAggregateProject(leftPartialQuery.getAggregateProject());
            }
            if (leftPartialQuery.getSortProject() != null) {
                newPartialQuery = newPartialQuery.withSortProject(leftPartialQuery.getSortProject());
            }
            if (leftPartialQuery.getSort() != null) {
                newPartialQuery = newPartialQuery.withSort(leftPartialQuery.getSort());
            }
            return this.left.withPartialQuery(newPartialQuery);
        }
        return null;
    }

    private RexNode makeAnd(List<RexNode> conditions) {
        if (conditions.size() == 1) {
            return (RexNode)Iterables.getOnlyElement(conditions);
        }
        return this.getCluster().getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, conditions);
    }

    private RexNode makeOr(List<RexNode> conditions) {
        if (conditions.size() == 1) {
            return (RexNode)Iterables.getOnlyElement(conditions);
        }
        return this.getCluster().getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, conditions);
    }
}

