/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.rel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import io.druid.data.input.Row;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.math.expr.Evals;
import io.druid.query.Query;
import io.druid.query.Result;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.scan.ScanQuery;
import io.druid.query.select.EventHolder;
import io.druid.query.select.PagingSpec;
import io.druid.query.select.SelectQuery;
import io.druid.query.select.SelectResultValue;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.query.topn.DimensionAndMetricValueExtractor;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNResultValue;
import io.druid.segment.DimensionHandlerUtils;
import io.druid.server.QueryLifecycleFactory;
import io.druid.server.security.AuthenticationResult;
import io.druid.sql.calcite.aggregation.DimensionExpression;
import io.druid.sql.calcite.planner.Calcites;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.rel.DruidQuery;
import io.druid.sql.calcite.table.RowSignature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;
import org.joda.time.DateTime;

public class QueryMaker {
    private final QueryLifecycleFactory queryLifecycleFactory;
    private final PlannerContext plannerContext;
    private final ObjectMapper jsonMapper;

    public QueryMaker(QueryLifecycleFactory queryLifecycleFactory, PlannerContext plannerContext, ObjectMapper jsonMapper) {
        this.queryLifecycleFactory = queryLifecycleFactory;
        this.plannerContext = plannerContext;
        this.jsonMapper = jsonMapper;
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    public ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public Sequence<Object[]> runQuery(DruidQuery druidQuery) {
        Query query = druidQuery.getQuery();
        if (query instanceof TimeseriesQuery) {
            return this.executeTimeseries(druidQuery, (TimeseriesQuery)query);
        }
        if (query instanceof TopNQuery) {
            return this.executeTopN(druidQuery, (TopNQuery)query);
        }
        if (query instanceof GroupByQuery) {
            return this.executeGroupBy(druidQuery, (GroupByQuery)query);
        }
        if (query instanceof ScanQuery) {
            return this.executeScan(druidQuery, (ScanQuery)query);
        }
        if (query instanceof SelectQuery) {
            return this.executeSelect(druidQuery, (SelectQuery)query);
        }
        throw new ISE("Cannot run query of class[%s]", new Object[]{query.getClass().getName()});
    }

    private Sequence<Object[]> executeScan(DruidQuery druidQuery, ScanQuery query) {
        int i;
        List fieldList = druidQuery.getOutputRowType().getFieldList();
        RowSignature outputRowSignature = druidQuery.getOutputRowSignature();
        int[] columnMapping = new int[outputRowSignature.getRowOrder().size()];
        HashMap scanColumnOrder = Maps.newHashMap();
        for (i = 0; i < query.getColumns().size(); ++i) {
            scanColumnOrder.put(query.getColumns().get(i), i);
        }
        for (i = 0; i < outputRowSignature.getRowOrder().size(); ++i) {
            Integer index = (Integer)scanColumnOrder.get(outputRowSignature.getRowOrder().get(i));
            columnMapping[i] = index == null ? -1 : index;
        }
        return Sequences.concat((Sequence)Sequences.map(this.runQuery((Query)query), scanResult -> {
            ArrayList<Object[]> retVals = new ArrayList<Object[]>();
            List rows = (List)scanResult.getEvents();
            for (List row : rows) {
                Object[] retVal = new Object[fieldList.size()];
                for (RelDataTypeField field : fieldList) {
                    retVal[field.getIndex()] = this.coerce(row.get(columnMapping[field.getIndex()]), field.getType().getSqlTypeName());
                }
                retVals.add(retVal);
            }
            return Sequences.simple(retVals);
        }));
    }

    private Sequence<Object[]> executeSelect(DruidQuery druidQuery, final SelectQuery baseQuery) {
        Preconditions.checkState((druidQuery.getGrouping() == null ? 1 : 0) != 0, (Object)"grouping must be null");
        final List fieldList = druidQuery.getOutputRowType().getFieldList();
        final Integer limit = druidQuery.getLimitSpec() != null ? Integer.valueOf(druidQuery.getLimitSpec().getLimit()) : null;
        final RowSignature outputRowSignature = druidQuery.getOutputRowSignature();
        Sequence sequenceOfSequences = Sequences.simple((Iterable)new Iterable<Sequence<Object[]>>(){

            @Override
            public Iterator<Sequence<Object[]>> iterator() {
                final AtomicBoolean morePages = new AtomicBoolean(true);
                final AtomicReference pagingIdentifiers = new AtomicReference();
                final AtomicLong rowsRead = new AtomicLong();
                return new Iterator<Sequence<Object[]>>(){

                    @Override
                    public boolean hasNext() {
                        return morePages.get();
                    }

                    @Override
                    public Sequence<Object[]> next() {
                        SelectQuery queryWithPagination = baseQuery.withPagingSpec(new PagingSpec((Map)pagingIdentifiers.get(), QueryMaker.this.plannerContext.getPlannerConfig().getSelectThreshold(), Boolean.valueOf(true)));
                        morePages.set(false);
                        final AtomicBoolean gotResult = new AtomicBoolean();
                        return Sequences.concat((Sequence)Sequences.map((Sequence)QueryMaker.this.runQuery((Query)queryWithPagination), (Function)new Function<Result<SelectResultValue>, Sequence<Object[]>>(){

                            public Sequence<Object[]> apply(Result<SelectResultValue> result) {
                                if (!gotResult.compareAndSet(false, true)) {
                                    throw new ISE("WTF?! Expected single result from Select query but got multiple!", new Object[0]);
                                }
                                pagingIdentifiers.set(((SelectResultValue)result.getValue()).getPagingIdentifiers());
                                ArrayList<Object[]> retVals = new ArrayList<Object[]>();
                                for (EventHolder holder : ((SelectResultValue)result.getValue()).getEvents()) {
                                    morePages.set(true);
                                    Map map = holder.getEvent();
                                    Object[] retVal = new Object[fieldList.size()];
                                    for (RelDataTypeField field : fieldList) {
                                        String outputName = outputRowSignature.getRowOrder().get(field.getIndex());
                                        if (outputName.equals("__time")) {
                                            retVal[field.getIndex()] = QueryMaker.this.coerce(holder.getTimestamp().getMillis(), field.getType().getSqlTypeName());
                                            continue;
                                        }
                                        retVal[field.getIndex()] = QueryMaker.this.coerce(map.get(outputName), field.getType().getSqlTypeName());
                                    }
                                    if (limit == null || rowsRead.incrementAndGet() <= (long)limit.intValue()) {
                                        retVals.add(retVal);
                                        continue;
                                    }
                                    morePages.set(false);
                                    return Sequences.simple(retVals);
                                }
                                return Sequences.simple(retVals);
                            }
                        }));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
        return Sequences.concat((Sequence)sequenceOfSequences);
    }

    private <T> Sequence<T> runQuery(Query<T> query) {
        Hook.QUERY_PLAN.run(query);
        AuthenticationResult authenticationResult = this.plannerContext.getAuthenticationResult();
        return this.queryLifecycleFactory.factorize().runSimple(query, authenticationResult, null);
    }

    private Sequence<Object[]> executeTimeseries(final DruidQuery druidQuery, TimeseriesQuery query) {
        final List fieldList = druidQuery.getOutputRowType().getFieldList();
        final String timeOutputName = druidQuery.getGrouping().getDimensions().isEmpty() ? null : ((DimensionExpression)Iterables.getOnlyElement(druidQuery.getGrouping().getDimensions())).getOutputName();
        return Sequences.map(this.runQuery((Query)query), (Function)new Function<Result<TimeseriesResultValue>, Object[]>(){

            public Object[] apply(Result<TimeseriesResultValue> result) {
                Map row = ((TimeseriesResultValue)result.getValue()).getBaseObject();
                Object[] retVal = new Object[fieldList.size()];
                for (RelDataTypeField field : fieldList) {
                    String outputName = druidQuery.getOutputRowSignature().getRowOrder().get(field.getIndex());
                    if (outputName.equals(timeOutputName)) {
                        retVal[field.getIndex()] = QueryMaker.this.coerce(result.getTimestamp(), field.getType().getSqlTypeName());
                        continue;
                    }
                    retVal[field.getIndex()] = QueryMaker.this.coerce(row.get(outputName), field.getType().getSqlTypeName());
                }
                return retVal;
            }
        });
    }

    private Sequence<Object[]> executeTopN(final DruidQuery druidQuery, TopNQuery query) {
        final List fieldList = druidQuery.getOutputRowType().getFieldList();
        return Sequences.concat((Sequence)Sequences.map(this.runQuery((Query)query), (Function)new Function<Result<TopNResultValue>, Sequence<Object[]>>(){

            public Sequence<Object[]> apply(Result<TopNResultValue> result) {
                List rows = ((TopNResultValue)result.getValue()).getValue();
                ArrayList<Object[]> retVals = new ArrayList<Object[]>(rows.size());
                for (DimensionAndMetricValueExtractor row : rows) {
                    Object[] retVal = new Object[fieldList.size()];
                    for (RelDataTypeField field : fieldList) {
                        String outputName = druidQuery.getOutputRowSignature().getRowOrder().get(field.getIndex());
                        retVal[field.getIndex()] = QueryMaker.this.coerce(row.getMetric(outputName), field.getType().getSqlTypeName());
                    }
                    retVals.add(retVal);
                }
                return Sequences.simple(retVals);
            }
        }));
    }

    private Sequence<Object[]> executeGroupBy(final DruidQuery druidQuery, GroupByQuery query) {
        final List fieldList = druidQuery.getOutputRowType().getFieldList();
        return Sequences.map(this.runQuery((Query)query), (Function)new Function<Row, Object[]>(){

            public Object[] apply(Row row) {
                Object[] retVal = new Object[fieldList.size()];
                for (RelDataTypeField field : fieldList) {
                    retVal[field.getIndex()] = QueryMaker.this.coerce(row.getRaw(druidQuery.getOutputRowSignature().getRowOrder().get(field.getIndex())), field.getType().getSqlTypeName());
                }
                return retVal;
            }
        });
    }

    public static ColumnMetaData.Rep rep(SqlTypeName sqlType) {
        if (SqlTypeName.CHAR_TYPES.contains(sqlType)) {
            return ColumnMetaData.Rep.of(String.class);
        }
        if (sqlType == SqlTypeName.TIMESTAMP) {
            return ColumnMetaData.Rep.of(Long.class);
        }
        if (sqlType == SqlTypeName.DATE) {
            return ColumnMetaData.Rep.of(Integer.class);
        }
        if (sqlType == SqlTypeName.INTEGER) {
            return ColumnMetaData.Rep.of(Integer.class);
        }
        if (sqlType == SqlTypeName.BIGINT) {
            return ColumnMetaData.Rep.of(Long.class);
        }
        if (sqlType == SqlTypeName.FLOAT) {
            return ColumnMetaData.Rep.of(Float.class);
        }
        if (sqlType == SqlTypeName.DOUBLE || sqlType == SqlTypeName.DECIMAL) {
            return ColumnMetaData.Rep.of(Double.class);
        }
        if (sqlType == SqlTypeName.BOOLEAN) {
            return ColumnMetaData.Rep.of(Boolean.class);
        }
        if (sqlType == SqlTypeName.OTHER) {
            return ColumnMetaData.Rep.of(Object.class);
        }
        throw new ISE("No rep for SQL type[%s]", new Object[]{sqlType});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object coerce(Object value, SqlTypeName sqlType) {
        if (SqlTypeName.CHAR_TYPES.contains(sqlType)) {
            if (value == null) return Strings.nullToEmpty((String)((String)value));
            if (value instanceof String) {
                return Strings.nullToEmpty((String)((String)value));
            }
            if (value instanceof NlsString) {
                return ((NlsString)value).getValue();
            }
            if (!(value instanceof Number)) throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            return String.valueOf(value);
        }
        if (value == null) {
            return null;
        }
        if (sqlType == SqlTypeName.DATE) {
            return Calcites.jodaToCalciteDate(QueryMaker.coerceDateTime(value, sqlType), this.plannerContext.getTimeZone());
        }
        if (sqlType == SqlTypeName.TIMESTAMP) {
            return Calcites.jodaToCalciteTimestamp(QueryMaker.coerceDateTime(value, sqlType), this.plannerContext.getTimeZone());
        }
        if (sqlType == SqlTypeName.BOOLEAN) {
            if (value instanceof String) {
                return Evals.asBoolean((String)((String)value));
            }
            if (!(value instanceof Number)) throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            return Evals.asBoolean((long)((Number)value).longValue());
        }
        if (sqlType == SqlTypeName.INTEGER) {
            if (value instanceof String) {
                return Ints.tryParse((String)((String)value));
            }
            if (!(value instanceof Number)) throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            return ((Number)value).intValue();
        }
        if (sqlType == SqlTypeName.BIGINT) {
            try {
                return DimensionHandlerUtils.convertObjectToLong((Object)value);
            }
            catch (Exception e) {
                throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            }
        }
        if (sqlType == SqlTypeName.FLOAT) {
            try {
                return DimensionHandlerUtils.convertObjectToFloat((Object)value);
            }
            catch (Exception e) {
                throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            }
        }
        if (SqlTypeName.FRACTIONAL_TYPES.contains(sqlType)) {
            try {
                return DimensionHandlerUtils.convertObjectToDouble((Object)value);
            }
            catch (Exception e) {
                throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            }
        }
        if (sqlType != SqlTypeName.OTHER) throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
        return value.getClass().getName();
    }

    private static DateTime coerceDateTime(Object value, SqlTypeName sqlType) {
        DateTime dateTime;
        if (value instanceof Number) {
            dateTime = DateTimes.utc((long)((Number)value).longValue());
        } else if (value instanceof String) {
            dateTime = DateTimes.utc((long)Long.parseLong((String)value));
        } else if (value instanceof DateTime) {
            dateTime = (DateTime)value;
        } else {
            throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
        }
        return dateTime;
    }
}

