/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.rel;

import com.google.common.base.Preconditions;
import io.druid.java.util.common.ISE;
import io.druid.query.aggregation.PostAggregator;
import io.druid.sql.calcite.table.RowSignature;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class SortProject {
    private final RowSignature inputRowSignature;
    private final List<PostAggregator> postAggregators;
    private final RowSignature outputRowSignature;

    SortProject(RowSignature inputRowSignature, List<PostAggregator> postAggregators, RowSignature outputRowSignature) {
        this.inputRowSignature = (RowSignature)Preconditions.checkNotNull((Object)inputRowSignature, (Object)"inputRowSignature");
        this.postAggregators = (List)Preconditions.checkNotNull(postAggregators, (Object)"postAggregators");
        this.outputRowSignature = (RowSignature)Preconditions.checkNotNull((Object)outputRowSignature, (Object)"outputRowSignature");
        HashSet<String> seen = new HashSet<String>();
        inputRowSignature.getRowOrder().forEach(field -> {
            if (!seen.add((String)field)) {
                throw new ISE("Duplicate field name: %s", new Object[]{field});
            }
        });
        for (PostAggregator postAggregator : postAggregators) {
            if (postAggregator == null) {
                throw new ISE("aggregation[%s] is not a postAggregator", new Object[]{postAggregator});
            }
            if (seen.add(postAggregator.getName())) continue;
            throw new ISE("Duplicate field name: %s", new Object[]{postAggregator.getName()});
        }
        outputRowSignature.getRowOrder().forEach(field -> {
            if (!seen.contains(field)) {
                throw new ISE("Missing field in rowOrder: %s", new Object[]{field});
            }
        });
    }

    public List<PostAggregator> getPostAggregators() {
        return this.postAggregators;
    }

    public RowSignature getOutputRowSignature() {
        return this.outputRowSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortProject sortProject = (SortProject)o;
        return Objects.equals(this.inputRowSignature, sortProject.inputRowSignature) && Objects.equals(this.postAggregators, sortProject.postAggregators) && Objects.equals(this.outputRowSignature, sortProject.outputRowSignature);
    }

    public int hashCode() {
        return Objects.hash(this.inputRowSignature, this.postAggregators, this.outputRowSignature);
    }

    public String toString() {
        return "SortProject{inputRowSignature=" + this.inputRowSignature + ", postAggregators=" + this.postAggregators + ", outputRowSignature=" + this.outputRowSignature + '}';
    }
}

