/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.rule;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import io.druid.sql.calcite.planner.PlannerConfig;
import io.druid.sql.calcite.rel.DruidRel;
import io.druid.sql.calcite.rel.DruidSemiJoin;
import io.druid.sql.calcite.rel.PartialDruidQuery;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;

public class DruidSemiJoinRule
extends RelOptRule {
    private static final Predicate<Join> IS_LEFT_OR_INNER = join -> {
        JoinRelType joinType = join.getJoinType();
        return joinType == JoinRelType.LEFT || joinType == JoinRelType.INNER;
    };
    private static final Predicate<DruidRel> IS_GROUP_BY = druidRel -> druidRel.getPartialDruidQuery().getAggregate() != null;
    private static final DruidSemiJoinRule INSTANCE = new DruidSemiJoinRule();

    private DruidSemiJoinRule() {
        super(DruidSemiJoinRule.operand(Project.class, (RelOptRuleOperand)DruidSemiJoinRule.operand(Join.class, null, IS_LEFT_OR_INNER, (RelOptRuleOperandChildren)DruidSemiJoinRule.some((RelOptRuleOperand)DruidSemiJoinRule.operand(DruidRel.class, null, (Predicate)Predicates.not(IS_GROUP_BY), (RelOptRuleOperandChildren)DruidSemiJoinRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{DruidSemiJoinRule.operand(DruidRel.class, null, IS_GROUP_BY, (RelOptRuleOperandChildren)DruidSemiJoinRule.any())})), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public static DruidSemiJoinRule instance() {
        return INSTANCE;
    }

    public void onMatch(RelOptRuleCall call) {
        ImmutableBitSet rightBits;
        Project project = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        DruidRel left = (DruidRel)call.rel(2);
        DruidRel right = (DruidRel)call.rel(3);
        ImmutableBitSet bits = RelOptUtil.InputFinder.bits((List)project.getProjects(), null);
        if (bits.intersects(rightBits = ImmutableBitSet.range((int)left.getRowType().getFieldCount(), (int)join.getRowType().getFieldCount()))) {
            return;
        }
        JoinInfo joinInfo = join.analyzeCondition();
        if (!joinInfo.isEqui() || joinInfo.rightSet().cardinality() != right.getPartialDruidQuery().getAggregate().getGroupCount()) {
            return;
        }
        PartialDruidQuery rightQuery = right.getPartialDruidQuery();
        Project rightProject = rightQuery.getSortProject() != null ? rightQuery.getSortProject() : rightQuery.getAggregateProject();
        int i = 0;
        Iterator iterator = joinInfo.rightSet().iterator();
        while (iterator.hasNext()) {
            int aggregateRef;
            int joinRef = (Integer)iterator.next();
            if (rightProject == null) {
                aggregateRef = joinRef;
            } else {
                RexNode projectExp = (RexNode)rightProject.getChildExps().get(joinRef);
                if (projectExp.isA(SqlKind.INPUT_REF)) {
                    aggregateRef = ((RexInputRef)projectExp).getIndex();
                } else {
                    return;
                }
            }
            if (aggregateRef == i++) continue;
            return;
        }
        RelBuilder relBuilder = call.builder();
        if (join.getJoinType() == JoinRelType.LEFT) {
            relBuilder.push((RelNode)left);
        } else {
            DruidSemiJoin druidSemiJoin = DruidSemiJoin.create(left, right, (List<Integer>)joinInfo.leftKeys, (List<Integer>)joinInfo.rightKeys, left.getPlannerContext());
            PlannerConfig plannerConfig = left.getPlannerContext().getPlannerConfig();
            if (plannerConfig.getMaxQueryCount() > 0 && druidSemiJoin.getQueryCount() > plannerConfig.getMaxQueryCount()) {
                return;
            }
            relBuilder.push((RelNode)druidSemiJoin);
        }
        call.transformTo(relBuilder.project((Iterable)project.getProjects(), (Iterable)project.getRowType().getFieldNames()).build());
    }
}

