/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.rule;

import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.FilteredAggregatorFactory;
import io.druid.query.filter.DimFilter;
import io.druid.sql.calcite.aggregation.Aggregation;
import io.druid.sql.calcite.aggregation.SqlAggregator;
import io.druid.sql.calcite.expression.Expressions;
import io.druid.sql.calcite.filtration.Filtration;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;

public class GroupByRules {
    private GroupByRules() {
    }

    public static Aggregation translateAggregateCall(PlannerContext plannerContext, RowSignature sourceRowSignature, RexBuilder rexBuilder, Project project, AggregateCall call, List<Aggregation> existingAggregations, String name, boolean finalizeAggregations) {
        DimFilter filter;
        if (call.filterArg >= 0) {
            if (project == null) {
                return null;
            }
            RexNode expression = (RexNode)project.getChildExps().get(call.filterArg);
            DimFilter nonOptimizedFilter = Expressions.toFilter(plannerContext, sourceRowSignature, expression);
            if (nonOptimizedFilter == null) {
                return null;
            }
            filter = Filtration.create(nonOptimizedFilter).optimizeFilterOnly(sourceRowSignature).getDimFilter();
        } else {
            filter = null;
        }
        SqlAggregator sqlAggregator = plannerContext.getOperatorTable().lookupAggregator(call.getAggregation());
        if (sqlAggregator == null) {
            return null;
        }
        ArrayList<Aggregation> existingAggregationsWithSameFilter = new ArrayList<Aggregation>();
        for (Aggregation existingAggregation : existingAggregations) {
            boolean doesMatch;
            if (filter == null) {
                doesMatch = existingAggregation.getAggregatorFactories().stream().allMatch(factory -> !(factory instanceof FilteredAggregatorFactory));
                if (!doesMatch) continue;
                existingAggregationsWithSameFilter.add(existingAggregation);
                continue;
            }
            doesMatch = existingAggregation.getAggregatorFactories().stream().allMatch(factory -> factory instanceof FilteredAggregatorFactory && ((FilteredAggregatorFactory)factory).getFilter().equals(filter));
            if (!doesMatch) continue;
            existingAggregationsWithSameFilter.add(Aggregation.create(existingAggregation.getVirtualColumns(), existingAggregation.getAggregatorFactories().stream().map(factory -> ((FilteredAggregatorFactory)factory).getAggregator()).collect(Collectors.toList()), existingAggregation.getPostAggregator()));
        }
        Aggregation retVal = sqlAggregator.toDruidAggregation(plannerContext, sourceRowSignature, rexBuilder, name, call, project, existingAggregationsWithSameFilter, finalizeAggregations);
        if (retVal == null) {
            return null;
        }
        if (GroupByRules.isUsingExistingAggregation(retVal, existingAggregationsWithSameFilter)) {
            return retVal;
        }
        return retVal.filter(sourceRowSignature, filter);
    }

    private static boolean isUsingExistingAggregation(Aggregation aggregation, List<Aggregation> existingAggregations) {
        if (!aggregation.getAggregatorFactories().isEmpty()) {
            return false;
        }
        Set existingAggregationNames = existingAggregations.stream().flatMap(xs -> xs.getAggregatorFactories().stream()).map(AggregatorFactory::getName).collect(Collectors.toSet());
        return aggregation.getPostAggregator().getDependentFields().stream().allMatch(existingAggregationNames::contains);
    }
}

