/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.rule;

import io.druid.java.util.common.ISE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.util.ImmutableBitSet;

public class ProjectAggregatePruneUnusedCallRule
extends RelOptRule {
    private static final ProjectAggregatePruneUnusedCallRule INSTANCE = new ProjectAggregatePruneUnusedCallRule();

    private ProjectAggregatePruneUnusedCallRule() {
        super(ProjectAggregatePruneUnusedCallRule.operand(Project.class, (RelOptRuleOperand)ProjectAggregatePruneUnusedCallRule.operand(Aggregate.class, (RelOptRuleOperandChildren)ProjectAggregatePruneUnusedCallRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public static ProjectAggregatePruneUnusedCallRule instance() {
        return INSTANCE;
    }

    public boolean matches(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(1);
        return !aggregate.indicator && aggregate.getGroupSets().size() == 1;
    }

    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        Aggregate aggregate = (Aggregate)call.rel(1);
        ImmutableBitSet projectBits = RelOptUtil.InputFinder.bits((List)project.getChildExps(), null);
        int fieldCount = aggregate.getGroupCount() + aggregate.getAggCallList().size();
        if (fieldCount != aggregate.getRowType().getFieldCount()) {
            throw new ISE("WTF, expected[%s] to have[%s] fields but it had[%s]", new Object[]{aggregate, fieldCount, aggregate.getRowType().getFieldCount()});
        }
        ImmutableBitSet callsToKeep = projectBits.intersect(ImmutableBitSet.range((int)aggregate.getGroupCount(), (int)fieldCount));
        if (callsToKeep.cardinality() < aggregate.getAggCallList().size()) {
            ArrayList newAggregateCalls = new ArrayList();
            Iterator iterator = callsToKeep.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                newAggregateCalls.add(aggregate.getAggCallList().get(i - aggregate.getGroupCount()));
            }
            Aggregate newAggregate = aggregate.copy(aggregate.getTraitSet(), aggregate.getInput(), aggregate.indicator, aggregate.getGroupSet(), (List)aggregate.getGroupSets(), newAggregateCalls);
            ArrayList<Object> fixUpProjects = new ArrayList<Object>();
            RexBuilder rexBuilder = aggregate.getCluster().getRexBuilder();
            for (int i = 0; i < aggregate.getGroupCount(); ++i) {
                fixUpProjects.add(rexBuilder.makeInputRef((RelNode)newAggregate, i));
            }
            int j = aggregate.getGroupCount();
            for (int i = aggregate.getGroupCount(); i < fieldCount; ++i) {
                if (callsToKeep.get(i)) {
                    fixUpProjects.add(rexBuilder.makeInputRef((RelNode)newAggregate, j++));
                    continue;
                }
                fixUpProjects.add(rexBuilder.makeNullLiteral(((RelDataTypeField)aggregate.getRowType().getFieldList().get(i)).getType()));
            }
            call.transformTo(call.builder().push((RelNode)newAggregate).project(fixUpProjects).project((Iterable)project.getChildExps()).build());
            call.getPlanner().setImportance((RelNode)project, 0.0);
        }
    }
}

