/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import io.druid.client.ServerView;
import io.druid.client.TimelineServerView;
import io.druid.guice.ManageLifecycle;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.concurrent.ScheduledExecutors;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Yielder;
import io.druid.java.util.common.guava.Yielders;
import io.druid.java.util.common.lifecycle.LifecycleStart;
import io.druid.java.util.common.lifecycle.LifecycleStop;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.query.DataSource;
import io.druid.query.Query;
import io.druid.query.TableDataSource;
import io.druid.query.metadata.metadata.AllColumnIncluderator;
import io.druid.query.metadata.metadata.ColumnAnalysis;
import io.druid.query.metadata.metadata.ColumnIncluderator;
import io.druid.query.metadata.metadata.SegmentAnalysis;
import io.druid.query.metadata.metadata.SegmentMetadataQuery;
import io.druid.query.spec.MultipleSpecificSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.segment.column.ValueType;
import io.druid.server.QueryLifecycleFactory;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.server.security.AuthenticationResult;
import io.druid.server.security.Escalator;
import io.druid.sql.calcite.planner.PlannerConfig;
import io.druid.sql.calcite.table.DruidTable;
import io.druid.sql.calcite.table.RowSignature;
import io.druid.sql.calcite.view.DruidViewMacro;
import io.druid.sql.calcite.view.ViewManager;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.joda.time.ReadablePeriod;

@ManageLifecycle
public class DruidSchema
extends AbstractSchema {
    private static final Comparator<DataSegment> SEGMENT_ORDER = Comparator.comparing(segment -> segment.getInterval().getStart()).reversed().thenComparing(java.util.function.Function.identity());
    public static final String NAME = "druid";
    private static final EmittingLogger log = new EmittingLogger(DruidSchema.class);
    private static final int MAX_SEGMENTS_PER_QUERY = 15000;
    private final QueryLifecycleFactory queryLifecycleFactory;
    private final TimelineServerView serverView;
    private final PlannerConfig config;
    private final ViewManager viewManager;
    private final ExecutorService cacheExec;
    private final ConcurrentMap<String, DruidTable> tables;
    private final CountDownLatch initializationLatch = new CountDownLatch(1);
    private final Object lock = new Object();
    private final Map<String, TreeMap<DataSegment, RowSignature>> segmentSignatures = new HashMap<String, TreeMap<DataSegment, RowSignature>>();
    private final Set<DataSegment> mutableSegments = new TreeSet<DataSegment>(SEGMENT_ORDER);
    private final Set<String> dataSourcesNeedingRebuild = new HashSet<String>();
    private final TreeSet<DataSegment> segmentsNeedingRefresh = new TreeSet<DataSegment>(SEGMENT_ORDER);
    private final Escalator escalator;
    private boolean refreshImmediately = false;
    private long lastRefresh = 0L;
    private long lastFailure = 0L;
    private boolean isServerViewInitialized = false;

    @Inject
    public DruidSchema(QueryLifecycleFactory queryLifecycleFactory, TimelineServerView serverView, PlannerConfig config, ViewManager viewManager, Escalator escalator) {
        this.queryLifecycleFactory = (QueryLifecycleFactory)Preconditions.checkNotNull((Object)queryLifecycleFactory, (Object)"queryLifecycleFactory");
        this.serverView = (TimelineServerView)Preconditions.checkNotNull((Object)serverView, (Object)"serverView");
        this.config = (PlannerConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.viewManager = (ViewManager)Preconditions.checkNotNull((Object)viewManager, (Object)"viewManager");
        this.cacheExec = ScheduledExecutors.fixed((int)1, (String)"DruidSchema-Cache-%d");
        this.tables = new ConcurrentHashMap<String, DruidTable>();
        this.escalator = escalator;
        serverView.registerTimelineCallback((Executor)MoreExecutors.sameThreadExecutor(), new TimelineServerView.TimelineCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ServerView.CallbackAction timelineInitialized() {
                Object object = DruidSchema.this.lock;
                synchronized (object) {
                    DruidSchema.this.isServerViewInitialized = true;
                    DruidSchema.this.lock.notifyAll();
                }
                return ServerView.CallbackAction.CONTINUE;
            }

            public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
                DruidSchema.this.addSegment(server, segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            public ServerView.CallbackAction segmentRemoved(DataSegment segment) {
                DruidSchema.this.removeSegment(segment);
                return ServerView.CallbackAction.CONTINUE;
            }
        });
    }

    @LifecycleStart
    public void start() {
        this.cacheExec.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block22: {
                    while (true) {
                        try {
                            Iterator iterator;
                            if (Thread.currentThread().isInterrupted()) break block22;
                            TreeSet segmentsToRefresh = new TreeSet();
                            TreeSet dataSourcesToRebuild = new TreeSet();
                            try {
                                Object object = DruidSchema.this.lock;
                                synchronized (object) {
                                    long nextRefreshNoFuzz = DateTimes.utc((long)DruidSchema.this.lastRefresh).plus((ReadablePeriod)DruidSchema.this.config.getMetadataRefreshPeriod()).getMillis();
                                    long nextRefresh = nextRefreshNoFuzz + (long)((double)(nextRefreshNoFuzz - DruidSchema.this.lastRefresh) * 0.1);
                                    while (true) {
                                        boolean wasRecentFailure = DateTimes.utc((long)DruidSchema.this.lastFailure).plus((ReadablePeriod)DruidSchema.this.config.getMetadataRefreshPeriod()).isAfterNow();
                                        if (!(!DruidSchema.this.isServerViewInitialized || wasRecentFailure || DruidSchema.this.segmentsNeedingRefresh.isEmpty() && DruidSchema.this.dataSourcesNeedingRebuild.isEmpty() || !DruidSchema.this.refreshImmediately && nextRefresh >= System.currentTimeMillis())) break;
                                        DruidSchema.this.lock.wait(Math.max(1L, nextRefresh - System.currentTimeMillis()));
                                    }
                                    segmentsToRefresh.addAll(DruidSchema.this.segmentsNeedingRefresh);
                                    DruidSchema.this.segmentsNeedingRefresh.clear();
                                    DruidSchema.this.segmentsNeedingRefresh.addAll(DruidSchema.this.mutableSegments);
                                    DruidSchema.this.lastFailure = 0L;
                                    DruidSchema.this.lastRefresh = System.currentTimeMillis();
                                    DruidSchema.this.refreshImmediately = false;
                                }
                                Set refreshed = DruidSchema.this.refreshSegments(segmentsToRefresh);
                                iterator = DruidSchema.this.lock;
                                synchronized (iterator) {
                                    DruidSchema.this.segmentsNeedingRefresh.addAll(Sets.difference(segmentsToRefresh, (Set)refreshed));
                                    dataSourcesToRebuild.addAll(DruidSchema.this.dataSourcesNeedingRebuild);
                                    refreshed.forEach(segment -> dataSourcesToRebuild.add(segment.getDataSource()));
                                    DruidSchema.this.dataSourcesNeedingRebuild.clear();
                                    DruidSchema.this.lock.notifyAll();
                                }
                                for (String dataSource : dataSourcesToRebuild) {
                                    DruidTable druidTable = DruidSchema.this.buildDruidTable(dataSource);
                                    DruidTable oldTable = DruidSchema.this.tables.put(dataSource, druidTable);
                                    if (oldTable == null || !oldTable.getRowSignature().equals(druidTable.getRowSignature())) {
                                        log.debug("Table for dataSource[%s] has new signature[%s].", new Object[]{dataSource, druidTable.getRowSignature()});
                                        continue;
                                    }
                                    log.debug("Table for dataSource[%s] signature is unchanged.", new Object[]{dataSource});
                                }
                                DruidSchema.this.initializationLatch.countDown();
                            }
                            catch (InterruptedException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                log.warn((Throwable)e, "Metadata refresh failed, trying again soon.", new Object[0]);
                                iterator = DruidSchema.this.lock;
                                synchronized (iterator) {
                                    DruidSchema.this.segmentsNeedingRefresh.addAll(segmentsToRefresh);
                                    DruidSchema.this.dataSourcesNeedingRebuild.addAll(dataSourcesToRebuild);
                                    DruidSchema.this.lastFailure = System.currentTimeMillis();
                                    DruidSchema.this.lock.notifyAll();
                                }
                            }
                        }
                        catch (InterruptedException segmentsToRefresh) {
                            break block22;
                        }
                        catch (Throwable e) {
                            log.makeAlert(e, "Metadata refresh failed permanently", new Object[0]).emit();
                            throw e;
                        }
                    }
                    finally {
                        log.info("Metadata refresh stopped.", new Object[0]);
                    }
                }
            }
        });
    }

    @LifecycleStop
    public void stop() {
        this.cacheExec.shutdownNow();
    }

    @VisibleForTesting
    public void awaitInitialization() throws InterruptedException {
        this.initializationLatch.await();
    }

    protected Map<String, Table> getTableMap() {
        return ImmutableMap.copyOf(this.tables);
    }

    protected Multimap<String, Function> getFunctionMultimap() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Map.Entry<String, DruidViewMacro> entry : this.viewManager.getViews().entrySet()) {
            builder.put(entry);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSegment(DruidServerMetadata server, DataSegment segment) {
        Object object = this.lock;
        synchronized (object) {
            Map knownSegments = this.segmentSignatures.get(segment.getDataSource());
            if (knownSegments == null || !knownSegments.containsKey(segment)) {
                this.setSegmentSignature(segment, null);
                this.segmentsNeedingRefresh.add(segment);
                if (!server.segmentReplicatable()) {
                    log.debug("Added new mutable segment[%s].", new Object[]{segment.getIdentifier()});
                    this.mutableSegments.add(segment);
                } else {
                    log.debug("Added new immutable segment[%s].", new Object[]{segment.getIdentifier()});
                }
            } else if (server.segmentReplicatable()) {
                this.mutableSegments.remove(segment);
                log.debug("Segment[%s] has become immutable.", new Object[]{segment.getIdentifier()});
            }
            if (!this.tables.containsKey(segment.getDataSource())) {
                this.refreshImmediately = true;
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSegment(DataSegment segment) {
        Object object = this.lock;
        synchronized (object) {
            log.debug("Segment[%s] is gone.", new Object[]{segment.getIdentifier()});
            this.dataSourcesNeedingRebuild.add(segment.getDataSource());
            this.segmentsNeedingRefresh.remove(segment);
            this.mutableSegments.remove(segment);
            Map dataSourceSegments = this.segmentSignatures.get(segment.getDataSource());
            dataSourceSegments.remove(segment);
            if (dataSourceSegments.isEmpty()) {
                this.segmentSignatures.remove(segment.getDataSource());
                this.tables.remove(segment.getDataSource());
                log.info("Removed all metadata for dataSource[%s].", new Object[]{segment.getDataSource()});
            }
            this.lock.notifyAll();
        }
    }

    private Set<DataSegment> refreshSegments(Set<DataSegment> segments) throws IOException {
        HashSet<DataSegment> retVal = new HashSet<DataSegment>();
        TreeMap<String, TreeSet> segmentMap = new TreeMap<String, TreeSet>();
        for (DataSegment dataSegment : segments) {
            segmentMap.computeIfAbsent(dataSegment.getDataSource(), x -> new TreeSet<DataSegment>(SEGMENT_ORDER)).add(dataSegment);
        }
        for (Map.Entry entry : segmentMap.entrySet()) {
            String dataSource = (String)entry.getKey();
            retVal.addAll(this.refreshSegmentsForDataSource(dataSource, (Set)entry.getValue()));
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<DataSegment> refreshSegmentsForDataSource(String dataSource, Set<DataSegment> segments) throws IOException {
        log.debug("Refreshing metadata for dataSource[%s].", new Object[]{dataSource});
        long startTime = System.currentTimeMillis();
        Map segmentMap = segments.stream().collect(Collectors.toMap(DataSegment::getIdentifier, java.util.function.Function.identity()));
        HashSet<DataSegment> retVal = new HashSet<DataSegment>();
        Sequence<SegmentAnalysis> sequence = DruidSchema.runSegmentMetadataQuery(this.queryLifecycleFactory, Iterables.limit(segments, (int)15000), this.escalator.createEscalatedAuthenticationResult());
        try (Yielder yielder = Yielders.each(sequence);){
            while (!yielder.isDone()) {
                SegmentAnalysis analysis = (SegmentAnalysis)yielder.get();
                DataSegment segment = (DataSegment)segmentMap.get(analysis.getId());
                if (segment == null) {
                    log.warn("Got analysis for segment[%s] we didn't ask for, ignoring.", new Object[]{analysis.getId()});
                } else {
                    RowSignature rowSignature = DruidSchema.analysisToRowSignature(analysis);
                    log.debug("Segment[%s] has signature[%s].", new Object[]{segment.getIdentifier(), rowSignature});
                    this.setSegmentSignature(segment, rowSignature);
                    retVal.add(segment);
                }
                yielder = yielder.next(null);
            }
        }
        log.info("Refreshed metadata for dataSource[%s] in %,d ms (%d segments queried, %d segments left).", new Object[]{dataSource, System.currentTimeMillis() - startTime, retVal.size(), segments.size() - retVal.size()});
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSegmentSignature(DataSegment segment, RowSignature rowSignature) {
        Object object = this.lock;
        synchronized (object) {
            this.segmentSignatures.computeIfAbsent(segment.getDataSource(), x -> new TreeMap(SEGMENT_ORDER)).put(segment, rowSignature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DruidTable buildDruidTable(String dataSource) {
        Object object = this.lock;
        synchronized (object) {
            TreeMap<DataSegment, RowSignature> segmentMap = this.segmentSignatures.get(dataSource);
            TreeMap<String, ValueType> columnTypes = new TreeMap<String, ValueType>();
            if (segmentMap != null) {
                for (RowSignature rowSignature : segmentMap.values()) {
                    if (rowSignature == null) continue;
                    for (String column : rowSignature.getRowOrder()) {
                        columnTypes.putIfAbsent(column, rowSignature.getColumnType(column));
                    }
                }
            }
            RowSignature.Builder builder = RowSignature.builder();
            columnTypes.forEach(builder::add);
            return new DruidTable((DataSource)new TableDataSource(dataSource), builder.build());
        }
    }

    private static Sequence<SegmentAnalysis> runSegmentMetadataQuery(QueryLifecycleFactory queryLifecycleFactory, Iterable<DataSegment> segments, AuthenticationResult authenticationResult) {
        String dataSource = (String)Iterables.getOnlyElement((Iterable)StreamSupport.stream(segments.spliterator(), false).map(DataSegment::getDataSource).collect(Collectors.toSet()));
        MultipleSpecificSegmentSpec querySegmentSpec = new MultipleSpecificSegmentSpec(StreamSupport.stream(segments.spliterator(), false).map(DataSegment::toDescriptor).collect(Collectors.toList()));
        SegmentMetadataQuery segmentMetadataQuery = new SegmentMetadataQuery((DataSource)new TableDataSource(dataSource), (QuerySegmentSpec)querySegmentSpec, (ColumnIncluderator)new AllColumnIncluderator(), Boolean.valueOf(false), (Map)ImmutableMap.of(), EnumSet.noneOf(SegmentMetadataQuery.AnalysisType.class), Boolean.valueOf(false), Boolean.valueOf(false));
        return queryLifecycleFactory.factorize().runSimple((Query)segmentMetadataQuery, authenticationResult, null);
    }

    private static RowSignature analysisToRowSignature(SegmentAnalysis analysis) {
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        for (Map.Entry entry : analysis.getColumns().entrySet()) {
            ValueType valueType;
            if (((ColumnAnalysis)entry.getValue()).isError()) continue;
            try {
                valueType = ValueType.valueOf((String)StringUtils.toUpperCase((String)((ColumnAnalysis)entry.getValue()).getType()));
            }
            catch (IllegalArgumentException e) {
                valueType = ValueType.COMPLEX;
            }
            rowSignatureBuilder.add((String)entry.getKey(), valueType);
        }
        return rowSignatureBuilder.build();
    }
}

