/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.table;

import com.google.common.base.Preconditions;
import io.druid.query.DataSource;
import io.druid.sql.calcite.table.RowSignature;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;

public class DruidTable
implements TranslatableTable {
    private final DataSource dataSource;
    private final RowSignature rowSignature;

    public DruidTable(DataSource dataSource, RowSignature rowSignature) {
        this.dataSource = (DataSource)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.rowSignature = (RowSignature)Preconditions.checkNotNull((Object)rowSignature, (Object)"rowSignature");
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public RowSignature getRowSignature() {
        return this.rowSignature;
    }

    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.TABLE;
    }

    public Statistic getStatistic() {
        return Statistics.UNKNOWN;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.rowSignature.getRelDataType(typeFactory);
    }

    public boolean isRolledUp(String column) {
        return false;
    }

    public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
        return true;
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable table) {
        return LogicalTableScan.create((RelOptCluster)context.getCluster(), (RelOptTable)table);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidTable that = (DruidTable)o;
        if (this.dataSource != null ? !this.dataSource.equals(that.dataSource) : that.dataSource != null) {
            return false;
        }
        return this.rowSignature != null ? this.rowSignature.equals(that.rowSignature) : that.rowSignature == null;
    }

    public int hashCode() {
        int result = this.dataSource != null ? this.dataSource.hashCode() : 0;
        result = 31 * result + (this.rowSignature != null ? this.rowSignature.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DruidTable{dataSource=" + this.dataSource + ", rowSignature=" + this.rowSignature + '}';
    }
}

