/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.view;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.druid.sql.calcite.planner.DruidPlanner;
import io.druid.sql.calcite.planner.PlannerFactory;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.ViewTable;

public class DruidViewMacro
implements TableMacro {
    private final PlannerFactory plannerFactory;
    private final String viewSql;

    public DruidViewMacro(PlannerFactory plannerFactory, String viewSql) {
        this.plannerFactory = plannerFactory;
        this.viewSql = viewSql;
    }

    public TranslatableTable apply(List<Object> arguments) {
        RelDataType rowType;
        try (DruidPlanner planner = this.plannerFactory.createPlanner(null);){
            rowType = planner.plan(this.viewSql).rowType();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return new ViewTable(null, RelDataTypeImpl.proto((RelDataType)rowType), this.viewSql, (List)ImmutableList.of((Object)"druid"), null);
    }

    public List<FunctionParameter> getParameters() {
        return ImmutableList.of();
    }
}

