/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.view;

import com.google.inject.Inject;
import io.druid.java.util.common.ISE;
import io.druid.sql.calcite.planner.PlannerFactory;
import io.druid.sql.calcite.view.DruidViewMacro;
import io.druid.sql.calcite.view.ViewManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.calcite.schema.TableMacro;

public class InProcessViewManager
implements ViewManager {
    private final ConcurrentMap<String, DruidViewMacro> views = new ConcurrentHashMap<String, DruidViewMacro>();

    @Inject
    public InProcessViewManager() {
    }

    @Override
    public void createView(PlannerFactory plannerFactory, String viewName, String viewSql) {
        TableMacro oldValue = this.views.putIfAbsent(viewName, new DruidViewMacro(plannerFactory, viewSql));
        if (oldValue != null) {
            throw new ISE("View[%s] already exists", new Object[]{viewName});
        }
    }

    @Override
    public void alterView(PlannerFactory plannerFactory, String viewName, String viewSql) {
        TableMacro oldValue = this.views.replace(viewName, new DruidViewMacro(plannerFactory, viewSql));
        if (oldValue != null) {
            throw new ISE("View[%s] does not exist", new Object[]{viewName});
        }
    }

    @Override
    public void dropView(String viewName) {
        TableMacro oldValue = (TableMacro)this.views.remove(viewName);
        if (oldValue == null) {
            throw new ISE("View[%s] does not exist", new Object[]{viewName});
        }
    }

    @Override
    public Map<String, DruidViewMacro> getViews() {
        return this.views;
    }
}

