/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.server.initialization.jetty.JettyBindings;
import io.druid.server.metrics.MetricsModule;
import io.druid.sql.avatica.AvaticaMonitor;
import io.druid.sql.avatica.AvaticaServerConfig;
import io.druid.sql.avatica.DruidAvaticaHandler;
import io.druid.sql.calcite.aggregation.SqlAggregator;
import io.druid.sql.calcite.expression.builtin.LookupOperatorConversion;
import io.druid.sql.calcite.planner.Calcites;
import io.druid.sql.calcite.planner.PlannerConfig;
import io.druid.sql.calcite.schema.DruidSchema;
import io.druid.sql.calcite.view.NoopViewManager;
import io.druid.sql.calcite.view.ViewManager;
import io.druid.sql.guice.SqlBindings;
import io.druid.sql.http.SqlResource;
import java.util.Properties;

public class SqlModule
implements Module {
    private static final String PROPERTY_SQL_ENABLE = "druid.sql.enable";
    private static final String PROPERTY_SQL_ENABLE_JSON_OVER_HTTP = "druid.sql.http.enable";
    private static final String PROPERTY_SQL_ENABLE_AVATICA = "druid.sql.avatica.enable";
    @Inject
    private Properties props;

    public void configure(Binder binder) {
        if (this.isEnabled()) {
            Calcites.setSystemProperties();
            JsonConfigProvider.bind((Binder)binder, (String)"druid.sql.planner", PlannerConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.sql.avatica", AvaticaServerConfig.class);
            LifecycleModule.register((Binder)binder, DruidSchema.class);
            binder.bind(ViewManager.class).to(NoopViewManager.class).in(LazySingleton.class);
            Multibinder.newSetBinder((Binder)binder, SqlAggregator.class);
            SqlBindings.addOperatorConversion(binder, LookupOperatorConversion.class);
            if (this.isJsonOverHttpEnabled()) {
                Jerseys.addResource((Binder)binder, SqlResource.class);
            }
            if (this.isAvaticaEnabled()) {
                binder.bind(AvaticaMonitor.class).in(LazySingleton.class);
                JettyBindings.addHandler((Binder)binder, DruidAvaticaHandler.class);
                MetricsModule.register((Binder)binder, AvaticaMonitor.class);
            }
        }
    }

    private boolean isEnabled() {
        Preconditions.checkNotNull((Object)this.props, (Object)"props");
        return Boolean.valueOf(this.props.getProperty(PROPERTY_SQL_ENABLE, "false"));
    }

    private boolean isJsonOverHttpEnabled() {
        Preconditions.checkNotNull((Object)this.props, (Object)"props");
        return Boolean.valueOf(this.props.getProperty(PROPERTY_SQL_ENABLE_JSON_OVER_HTTP, "true"));
    }

    private boolean isAvaticaEnabled() {
        Preconditions.checkNotNull((Object)this.props, (Object)"props");
        return Boolean.valueOf(this.props.getProperty(PROPERTY_SQL_ENABLE_AVATICA, "true"));
    }
}

