/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.druid.java.util.common.StringUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class SqlQuery {
    private final String query;
    private final ResultFormat resultFormat;
    private final Map<String, Object> context;

    @JsonCreator
    public SqlQuery(@JsonProperty(value="query") String query, @JsonProperty(value="resultFormat") ResultFormat resultFormat, @JsonProperty(value="context") Map<String, Object> context) {
        this.query = (String)Preconditions.checkNotNull((Object)query, (Object)"query");
        this.resultFormat = resultFormat == null ? ResultFormat.OBJECT : resultFormat;
        this.context = context == null ? ImmutableMap.of() : context;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public ResultFormat getResultFormat() {
        return this.resultFormat;
    }

    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlQuery sqlQuery = (SqlQuery)o;
        return Objects.equals(this.query, sqlQuery.query) && this.resultFormat == sqlQuery.resultFormat && Objects.equals(this.context, sqlQuery.context);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.resultFormat, this.context});
    }

    public String toString() {
        return "SqlQuery{query='" + this.query + '\'' + ", resultFormat=" + (Object)((Object)this.resultFormat) + ", context=" + this.context + '}';
    }

    public static enum ResultFormat {
        ARRAY{

            @Override
            public void writeResultStart(JsonGenerator jsonGenerator) throws IOException {
                jsonGenerator.writeStartArray();
            }

            @Override
            public void writeResultField(JsonGenerator jsonGenerator, String name, Object value) throws IOException {
                jsonGenerator.writeObject(value);
            }

            @Override
            public void writeResultEnd(JsonGenerator jsonGenerator) throws IOException {
                jsonGenerator.writeEndArray();
            }
        }
        ,
        OBJECT{

            @Override
            public void writeResultStart(JsonGenerator jsonGenerator) throws IOException {
                jsonGenerator.writeStartObject();
            }

            @Override
            public void writeResultField(JsonGenerator jsonGenerator, String name, Object value) throws IOException {
                jsonGenerator.writeFieldName(name);
                jsonGenerator.writeObject(value);
            }

            @Override
            public void writeResultEnd(JsonGenerator jsonGenerator) throws IOException {
                jsonGenerator.writeEndObject();
            }
        };


        public abstract void writeResultStart(JsonGenerator var1) throws IOException;

        public abstract void writeResultField(JsonGenerator var1, String var2, Object var3) throws IOException;

        public abstract void writeResultEnd(JsonGenerator var1) throws IOException;

        @JsonCreator
        public static ResultFormat fromString(@Nullable String name) {
            if (name == null) {
                return null;
            }
            return ResultFormat.valueOf(StringUtils.toUpperCase((String)name));
        }
    }
}

