/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.http;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.druid.guice.annotations.Json;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.guava.Yielder;
import io.druid.java.util.common.guava.Yielders;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.QueryInterruptedException;
import io.druid.sql.calcite.planner.Calcites;
import io.druid.sql.calcite.planner.DruidPlanner;
import io.druid.sql.calcite.planner.PlannerFactory;
import io.druid.sql.calcite.planner.PlannerResult;
import io.druid.sql.http.SqlQuery;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

@Path(value="/druid/v2/sql/")
public class SqlResource {
    private static final Logger log = new Logger(SqlResource.class);
    private final ObjectMapper jsonMapper;
    private final PlannerFactory plannerFactory;

    @Inject
    public SqlResource(@Json ObjectMapper jsonMapper, PlannerFactory plannerFactory) {
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"jsonMapper");
        this.plannerFactory = (PlannerFactory)Preconditions.checkNotNull((Object)plannerFactory, (Object)"connection");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response doPost(final SqlQuery sqlQuery, @Context HttpServletRequest req) throws SQLException, IOException {
        try {
            Throwable throwable = null;
            try (DruidPlanner planner = this.plannerFactory.createPlanner(sqlQuery.getContext());){
                SqlTypeName sqlTypeName;
                PlannerResult plannerResult = planner.plan(sqlQuery.getQuery(), req, null);
                final DateTimeZone timeZone = planner.getPlannerContext().getTimeZone();
                final List fieldList = plannerResult.rowType().getFieldList();
                final boolean[] timeColumns = new boolean[fieldList.size()];
                final boolean[] dateColumns = new boolean[fieldList.size()];
                for (int i = 0; i < fieldList.size(); ++i) {
                    sqlTypeName = ((RelDataTypeField)fieldList.get(i)).getType().getSqlTypeName();
                    timeColumns[i] = sqlTypeName == SqlTypeName.TIMESTAMP;
                    dateColumns[i] = sqlTypeName == SqlTypeName.DATE;
                }
                final Yielder yielder0 = Yielders.each(plannerResult.run());
                try {
                    sqlTypeName = Response.ok((Object)new StreamingOutput(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                            try (Yielder yielder = yielder0;
                                 JsonGenerator jsonGenerator = SqlResource.this.jsonMapper.getFactory().createGenerator(outputStream);){
                                jsonGenerator.writeStartArray();
                                while (!yielder.isDone()) {
                                    Object[] row = (Object[])yielder.get();
                                    sqlQuery.getResultFormat().writeResultStart(jsonGenerator);
                                    for (int i = 0; i < fieldList.size(); ++i) {
                                        Object value = timeColumns[i] ? ISODateTimeFormat.dateTime().print((ReadableInstant)Calcites.calciteTimestampToJoda((Long)row[i], timeZone)) : (dateColumns[i] ? ISODateTimeFormat.dateTime().print((ReadableInstant)Calcites.calciteDateToJoda((Integer)row[i], timeZone)) : row[i]);
                                        sqlQuery.getResultFormat().writeResultField(jsonGenerator, ((RelDataTypeField)fieldList.get(i)).getName(), value);
                                    }
                                    sqlQuery.getResultFormat().writeResultEnd(jsonGenerator);
                                    yielder = yielder.next(null);
                                }
                                jsonGenerator.writeEndArray();
                                jsonGenerator.flush();
                                outputStream.write(13);
                                outputStream.write(10);
                            }
                        }
                    }).build();
                    return sqlTypeName;
                }
                catch (Throwable e) {
                    try {
                        yielder0.close();
                        throw Throwables.propagate((Throwable)e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to handle query: %s", new Object[]{sqlQuery});
            Exception exceptionToReport = e instanceof RelOptPlanner.CannotPlanException ? new ISE("Cannot build plan for query: %s", new Object[]{sqlQuery.getQuery()}) : e;
            return Response.serverError().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.jsonMapper.writeValueAsBytes((Object)QueryInterruptedException.wrapIfNeeded((Throwable)exceptionToReport))).build();
        }
    }
}

