/*
 * Decompiled with CFR 0.152.
 */
package io.druid.extendedset.intset;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import io.druid.extendedset.intset.BitIterator;
import io.druid.extendedset.intset.ConciseSet;
import io.druid.extendedset.intset.ConciseSetUtils;
import io.druid.extendedset.intset.EmptyIntIterator;
import io.druid.extendedset.intset.IntSet;
import io.druid.extendedset.utilities.IntList;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.roaringbitmap.IntIterator;

public class ImmutableConciseSet {
    private static final int CHUNK_SIZE = 10000;
    private static final Comparator<WordIterator> UNION_COMPARATOR = new Comparator<WordIterator>(){

        @Override
        public int compare(WordIterator i1, WordIterator i2) {
            int s2;
            int s1 = i1.startIndex;
            if (s1 != (s2 = i2.startIndex)) {
                return Integer.compare(s1, s2);
            }
            int w1 = i1.getWord();
            int w2 = i2.getWord();
            if (ConciseSetUtils.isLiteral(w1)) {
                if (ConciseSetUtils.isLiteral(w2)) {
                    return 0;
                }
                if (ConciseSetUtils.isZeroSequence(w2)) {
                    return -1;
                }
                assert (ConciseSetUtils.isOneSequence(w2));
                return 1;
            }
            if (ConciseSetUtils.isZeroSequence(w1)) {
                if (!ConciseSetUtils.isZeroSequence(w2)) {
                    return 1;
                }
                return Integer.compare(ConciseSetUtils.getSequenceNumWords(w1), ConciseSetUtils.getSequenceNumWords(w2));
            }
            assert (ConciseSetUtils.isOneSequence(w1));
            if (ConciseSetUtils.isOneSequence(w2)) {
                return Integer.compare(ConciseSetUtils.getSequenceNumWords(w2), ConciseSetUtils.getSequenceNumWords(w1));
            }
            return -1;
        }
    };
    private static final Comparator<WordIterator> INTERSECTION_COMPARATOR = new Comparator<WordIterator>(){

        @Override
        public int compare(WordIterator i1, WordIterator i2) {
            int s2;
            int s1 = i1.startIndex;
            if (s1 != (s2 = i2.startIndex)) {
                return Integer.compare(s1, s2);
            }
            int w1 = i1.getWord();
            int w2 = i2.getWord();
            if (ConciseSetUtils.isLiteral(w1)) {
                if (ConciseSetUtils.isLiteral(w2)) {
                    return 0;
                }
                if (ConciseSetUtils.isZeroSequence(w2)) {
                    return 1;
                }
                assert (ConciseSetUtils.isOneSequence(w2));
                return -1;
            }
            if (ConciseSetUtils.isZeroSequence(w1)) {
                if (ConciseSetUtils.isZeroSequence(w2)) {
                    return Integer.compare(ConciseSetUtils.getSequenceNumWords(w2), ConciseSetUtils.getSequenceNumWords(w1));
                }
                return -1;
            }
            assert (ConciseSetUtils.isOneSequence(w1));
            if (!ConciseSetUtils.isOneSequence(w2)) {
                return 1;
            }
            return Integer.compare(ConciseSetUtils.getSequenceNumWords(w1), ConciseSetUtils.getSequenceNumWords(w2));
        }
    };
    final IntBuffer words;
    final int lastWordIndex;
    private final int size;

    public static ImmutableConciseSet newImmutableFromMutable(ConciseSet conciseSet) {
        if (conciseSet == null || conciseSet.isEmpty()) {
            return new ImmutableConciseSet();
        }
        return new ImmutableConciseSet(IntBuffer.wrap(conciseSet.getWords()));
    }

    public static ImmutableConciseSet union(ImmutableConciseSet ... sets) {
        return ImmutableConciseSet.union(Arrays.asList(sets));
    }

    public static ImmutableConciseSet union(Iterable<ImmutableConciseSet> sets) {
        return ImmutableConciseSet.union(sets.iterator());
    }

    public static ImmutableConciseSet union(Iterator<ImmutableConciseSet> sets) {
        ImmutableConciseSet partialResults = ImmutableConciseSet.doUnion(Iterators.limit(sets, (int)10000));
        while (sets.hasNext()) {
            UnmodifiableIterator partialIter = Iterators.singletonIterator((Object)partialResults);
            partialResults = ImmutableConciseSet.doUnion(Iterators.concat((Iterator)partialIter, (Iterator)Iterators.limit(sets, (int)10000)));
        }
        return partialResults;
    }

    public static ImmutableConciseSet intersection(ImmutableConciseSet ... sets) {
        return ImmutableConciseSet.intersection(Arrays.asList(sets));
    }

    public static ImmutableConciseSet intersection(Iterable<ImmutableConciseSet> sets) {
        return ImmutableConciseSet.intersection(sets.iterator());
    }

    public static ImmutableConciseSet intersection(Iterator<ImmutableConciseSet> sets) {
        ImmutableConciseSet partialResults = ImmutableConciseSet.doIntersection(Iterators.limit(sets, (int)10000));
        while (sets.hasNext()) {
            UnmodifiableIterator partialIter = Iterators.singletonIterator((Object)partialResults);
            partialResults = ImmutableConciseSet.doIntersection(Iterators.concat((Iterator)Iterators.limit(sets, (int)10000), (Iterator)partialIter));
        }
        return partialResults;
    }

    public static ImmutableConciseSet complement(ImmutableConciseSet set) {
        return ImmutableConciseSet.doComplement(set);
    }

    public static ImmutableConciseSet complement(ImmutableConciseSet set, int length) {
        int lastWord;
        if (length <= 0) {
            return new ImmutableConciseSet();
        }
        if (set == null || set.isEmpty()) {
            int leftoverBits = length % 31;
            int onesBlocks = length / 31;
            int[] words = onesBlocks > 0 ? (leftoverBits > 0 ? new int[]{0x40000000 | onesBlocks - 1, ConciseSetUtils.onesUntil(leftoverBits)} : new int[]{0x40000000 | onesBlocks - 1}) : (leftoverBits > 0 ? new int[]{ConciseSetUtils.onesUntil(leftoverBits)} : new int[]{});
            ConciseSet newSet = new ConciseSet(words, false);
            return ImmutableConciseSet.newImmutableFromMutable(newSet);
        }
        IntList retVal = new IntList();
        int endIndex = length - 1;
        int wordsWalked = 0;
        int last = 0;
        WordIterator iter = set.newWordIterator();
        while (iter.hasNext()) {
            int word = iter.next();
            wordsWalked = iter.wordsWalked;
            if (ConciseSetUtils.isLiteral(word)) {
                retVal.add(Integer.MIN_VALUE | ~word);
                continue;
            }
            retVal.add(0x40000000 ^ word);
        }
        last = set.getLast();
        int distFromLastWordBoundary = ConciseSetUtils.maxLiteralLengthModulus(last);
        int distToNextWordBoundary = 31 - distFromLastWordBoundary - 1;
        int diff = endIndex - (last = last < 0 ? 0 : last + distToNextWordBoundary);
        if (diff > 0) {
            if (diff <= 31) {
                retVal.add(-1);
            } else {
                int endIndexWordCount = ConciseSetUtils.maxLiteralLengthDivision(endIndex);
                retVal.add(0x40000000 | endIndexWordCount - wordsWalked - 1);
                retVal.add(-1);
            }
        }
        if (ConciseSetUtils.isLiteral(lastWord = retVal.get(retVal.length() - 1))) {
            lastWord = ConciseSetUtils.clearBitsAfterInLastWord(lastWord, ConciseSetUtils.maxLiteralLengthModulus(endIndex));
        }
        retVal.set(retVal.length() - 1, lastWord);
        ImmutableConciseSet.trimZeros(retVal);
        if (retVal.isEmpty()) {
            return new ImmutableConciseSet();
        }
        return ImmutableConciseSet.compact(new ImmutableConciseSet(IntBuffer.wrap(retVal.toArray())));
    }

    public static ImmutableConciseSet compact(ImmutableConciseSet set) {
        IntList retVal = new IntList();
        WordIterator itr = set.newWordIterator();
        while (itr.hasNext()) {
            ImmutableConciseSet.addAndCompact(retVal, itr.next());
        }
        return new ImmutableConciseSet(IntBuffer.wrap(retVal.toArray()));
    }

    private static void addAndCompact(IntList set, int wordToAdd) {
        int length = set.length();
        if (set.isEmpty()) {
            set.add(wordToAdd);
            return;
        }
        int last = set.get(length - 1);
        int newWord = 0;
        if (ConciseSetUtils.isLiteral(last)) {
            if (ConciseSetUtils.isLiteralWithSingleOneBit(last)) {
                int position = Integer.numberOfTrailingZeros(last) + 1;
                if (ConciseSetUtils.isAllZerosLiteral(wordToAdd)) {
                    newWord = 1 | position << 25;
                } else if (ConciseSetUtils.isZeroSequence(wordToAdd) && ConciseSetUtils.getFlippedBit(wordToAdd) == -1) {
                    newWord = wordToAdd + 1 | position << 25;
                }
            } else if (ConciseSetUtils.isAllZerosLiteral(last)) {
                if (ConciseSetUtils.isAllZerosLiteral(wordToAdd)) {
                    newWord = 1;
                } else if (ConciseSetUtils.isZeroSequence(wordToAdd) && ConciseSetUtils.getFlippedBit(wordToAdd) == -1) {
                    newWord = wordToAdd + 1;
                }
            } else if (ConciseSetUtils.isLiteralWithSingleZeroBit(last)) {
                int position = Integer.numberOfTrailingZeros(~last) + 1;
                if (ConciseSetUtils.isAllOnesLiteral(wordToAdd)) {
                    newWord = 0x40000001 | position << 25;
                } else if (ConciseSetUtils.isOneSequence(wordToAdd) && ConciseSetUtils.getFlippedBit(wordToAdd) == -1) {
                    newWord = wordToAdd + 1 | position << 25;
                }
            } else if (ConciseSetUtils.isAllOnesLiteral(last)) {
                if (ConciseSetUtils.isAllOnesLiteral(wordToAdd)) {
                    newWord = 0x40000001;
                } else if (ConciseSetUtils.isOneSequence(wordToAdd) && ConciseSetUtils.getFlippedBit(wordToAdd) == -1) {
                    newWord = wordToAdd + 1;
                }
            }
        } else if (ConciseSetUtils.isZeroSequence(last)) {
            if (ConciseSetUtils.isAllZerosLiteral(wordToAdd)) {
                newWord = last + 1;
            } else if (ConciseSetUtils.isZeroSequence(wordToAdd) && ConciseSetUtils.getFlippedBit(wordToAdd) == -1) {
                newWord = last + ConciseSetUtils.getSequenceNumWords(wordToAdd);
            }
        } else {
            assert (ConciseSetUtils.isOneSequence(last));
            if (ConciseSetUtils.isAllOnesLiteral(wordToAdd)) {
                newWord = last + 1;
            } else if (ConciseSetUtils.isOneSequence(wordToAdd) && ConciseSetUtils.getFlippedBit(wordToAdd) == -1) {
                newWord = last + ConciseSetUtils.getSequenceNumWords(wordToAdd);
            }
        }
        if (newWord != 0) {
            set.set(length - 1, newWord);
        } else {
            set.add(wordToAdd);
        }
    }

    private static ImmutableConciseSet doUnion(Iterator<ImmutableConciseSet> sets) {
        IntList retVal = new IntList();
        PriorityQueue<WordIterator> theQ = new PriorityQueue<WordIterator>(11, UNION_COMPARATOR);
        while (sets.hasNext()) {
            ImmutableConciseSet set = sets.next();
            if (set == null || set.isEmpty()) continue;
            WordIterator itr = set.newWordIterator();
            itr.word = itr.next();
            theQ.add(itr);
        }
        int currIndex = 0;
        ArrayList<WordIterator> changedIterators = new ArrayList<WordIterator>();
        while (!theQ.isEmpty()) {
            int w;
            WordIterator itr = theQ.poll();
            int word = itr.getWord();
            if (currIndex < itr.startIndex) {
                ImmutableConciseSet.addAndCompact(retVal, itr.startIndex - currIndex - 1);
                currIndex = itr.startIndex;
            }
            if (ConciseSetUtils.isLiteral(word)) {
                while (!theQ.isEmpty() && theQ.peek().startIndex == itr.startIndex) {
                    WordIterator i = theQ.poll();
                    int w2 = i.getWord();
                    if (ConciseSetUtils.isLiteral(w2)) {
                        word |= w2;
                    } else {
                        int flipBitLiteral = ConciseSetUtils.getLiteralFromZeroSeqFlipBit(w2);
                        if (flipBitLiteral != Integer.MIN_VALUE) {
                            word |= flipBitLiteral;
                            i.advanceTo(itr.wordsWalked);
                        }
                    }
                    if (!i.hasNext()) continue;
                    i.word = i.next();
                    changedIterators.add(i);
                }
                ImmutableConciseSet.addAndCompact(retVal, word);
                ++currIndex;
                if (itr.hasNext()) {
                    itr.word = itr.next();
                    changedIterators.add(itr);
                }
            } else if (ConciseSetUtils.isZeroSequence(word)) {
                int flipBitLiteral;
                while (!theQ.isEmpty() && theQ.peek().startIndex == itr.startIndex) {
                    WordIterator i = theQ.poll();
                    w = i.getWord();
                    flipBitLiteral = ConciseSetUtils.getLiteralFromZeroSeqFlipBit(w);
                    if (flipBitLiteral != Integer.MIN_VALUE) {
                        i.word = flipBitLiteral;
                        changedIterators.add(i);
                        continue;
                    }
                    if (!i.hasNext()) continue;
                    i.word = i.next();
                    changedIterators.add(i);
                }
                flipBitLiteral = ConciseSetUtils.getLiteralFromZeroSeqFlipBit(word);
                if (flipBitLiteral != Integer.MIN_VALUE) {
                    itr.word = flipBitLiteral;
                    changedIterators.add(itr);
                } else if (itr.hasNext()) {
                    itr.word = itr.next();
                    changedIterators.add(itr);
                }
            } else {
                assert (ConciseSetUtils.isOneSequence(word));
                int flipBitLiteral = ConciseSetUtils.getLiteralFromOneSeqFlipBit(word);
                while (!theQ.isEmpty() && theQ.peek().startIndex < itr.wordsWalked) {
                    WordIterator i = theQ.poll();
                    w = i.getWord();
                    if (i.startIndex == itr.startIndex) {
                        if (ConciseSetUtils.isLiteral(w)) {
                            flipBitLiteral |= w;
                        } else if (ConciseSetUtils.isZeroSequence(w)) {
                            flipBitLiteral |= ConciseSetUtils.getLiteralFromZeroSeqFlipBit(w);
                        } else {
                            assert (ConciseSetUtils.isOneSequence(w));
                            flipBitLiteral |= ConciseSetUtils.getLiteralFromOneSeqFlipBit(w);
                        }
                    }
                    i.advanceTo(itr.wordsWalked);
                    if (!i.hasNext()) continue;
                    i.word = i.next();
                    changedIterators.add(i);
                }
                int newWord = word & 0xC1FFFFFF;
                if (flipBitLiteral != -1) {
                    int position = Integer.numberOfTrailingZeros(flipBitLiteral ^= 0xFFFFFFFF) + 1;
                    newWord |= position << 25;
                }
                ImmutableConciseSet.addAndCompact(retVal, newWord);
                currIndex = itr.wordsWalked;
                if (itr.hasNext()) {
                    itr.word = itr.next();
                    changedIterators.add(itr);
                }
            }
            theQ.addAll(changedIterators);
            changedIterators.clear();
        }
        if (retVal.isEmpty()) {
            return new ImmutableConciseSet();
        }
        return new ImmutableConciseSet(IntBuffer.wrap(retVal.toArray()));
    }

    public static ImmutableConciseSet doIntersection(Iterator<ImmutableConciseSet> sets) {
        IntList retVal = new IntList();
        ArrayList<WordIterator> iterators = new ArrayList<WordIterator>();
        while (sets.hasNext()) {
            ImmutableConciseSet set = sets.next();
            if (set == null || set.isEmpty()) {
                return new ImmutableConciseSet();
            }
            WordIterator itr = set.newWordIterator();
            itr.word = itr.next();
            iterators.add(itr);
        }
        WordIterator[] theQ = iterators.toArray(new WordIterator[0]);
        int qSize = theQ.length;
        ImmutableConciseSet.partialSort(theQ, qSize - 1, qSize, INTERSECTION_COMPARATOR);
        int currIndex = 0;
        int wordsWalkedAtSequenceEnd = Integer.MAX_VALUE;
        while (qSize > 0) {
            int w;
            int qIndex;
            int flipBitLiteral;
            int maxChangedIndex = -1;
            WordIterator itr = theQ[0];
            int word = itr.getWord();
            if (itr.startIndex >= wordsWalkedAtSequenceEnd) break;
            if (currIndex < itr.startIndex) {
                ImmutableConciseSet.addAndCompact(retVal, 0x40000000 | itr.startIndex - currIndex - 1);
                currIndex = itr.startIndex;
            }
            if (ConciseSetUtils.isLiteral(word)) {
                int qIndex2 = 1;
                while (qIndex2 < qSize && theQ[qIndex2].startIndex == itr.startIndex) {
                    WordIterator i = theQ[qIndex2];
                    int w2 = i.getWord();
                    if (ConciseSetUtils.isLiteral(w2)) {
                        word &= w2;
                    } else {
                        int flipBitLiteral2 = ConciseSetUtils.getLiteralFromOneSeqFlipBit(w2);
                        if (flipBitLiteral2 != -1) {
                            word &= flipBitLiteral2;
                            i.advanceTo(itr.wordsWalked);
                        }
                    }
                    if (i.hasNext()) {
                        i.word = i.next();
                        maxChangedIndex = qIndex2++;
                        continue;
                    }
                    ImmutableConciseSet.removeElement(theQ, qIndex2, qSize);
                    --qSize;
                    wordsWalkedAtSequenceEnd = Math.min(i.wordsWalked, wordsWalkedAtSequenceEnd);
                }
                ImmutableConciseSet.addAndCompact(retVal, word);
                ++currIndex;
                if (itr.hasNext()) {
                    itr.word = itr.next();
                    maxChangedIndex = Math.max(maxChangedIndex, 0);
                } else {
                    ImmutableConciseSet.removeElement(theQ, 0, qSize);
                    --qSize;
                    wordsWalkedAtSequenceEnd = Math.min(itr.wordsWalked, wordsWalkedAtSequenceEnd);
                }
            } else if (ConciseSetUtils.isZeroSequence(word)) {
                flipBitLiteral = ConciseSetUtils.getLiteralFromZeroSeqFlipBit(word);
                qIndex = 1;
                while (qIndex < qSize && theQ[qIndex].startIndex < itr.wordsWalked) {
                    WordIterator i = theQ[qIndex];
                    w = i.getWord();
                    if (i.startIndex == itr.startIndex) {
                        if (ConciseSetUtils.isLiteral(w)) {
                            flipBitLiteral &= w;
                        } else if (ConciseSetUtils.isZeroSequence(w)) {
                            flipBitLiteral &= ConciseSetUtils.getLiteralFromZeroSeqFlipBit(w);
                        } else {
                            assert (ConciseSetUtils.isOneSequence(w));
                            flipBitLiteral &= ConciseSetUtils.getLiteralFromOneSeqFlipBit(w);
                        }
                    }
                    i.advanceTo(itr.wordsWalked);
                    if (i.hasNext()) {
                        i.word = i.next();
                        maxChangedIndex = qIndex++;
                        continue;
                    }
                    ImmutableConciseSet.removeElement(theQ, qIndex, qSize);
                    --qSize;
                    wordsWalkedAtSequenceEnd = Math.min(i.wordsWalked, wordsWalkedAtSequenceEnd);
                }
                int newWord = word & 0xC1FFFFFF;
                if (flipBitLiteral != Integer.MIN_VALUE) {
                    int position = Integer.numberOfTrailingZeros(flipBitLiteral) + 1;
                    newWord = word & 0xC1FFFFFF | position << 25;
                }
                ImmutableConciseSet.addAndCompact(retVal, newWord);
                currIndex = itr.wordsWalked;
                if (itr.hasNext()) {
                    itr.word = itr.next();
                    maxChangedIndex = Math.max(maxChangedIndex, 0);
                } else {
                    ImmutableConciseSet.removeElement(theQ, 0, qSize);
                    --qSize;
                    wordsWalkedAtSequenceEnd = Math.min(itr.wordsWalked, wordsWalkedAtSequenceEnd);
                }
            } else {
                assert (ConciseSetUtils.isOneSequence(word));
                qIndex = 1;
                while (qIndex < qSize && theQ[qIndex].startIndex == itr.startIndex) {
                    WordIterator i = theQ[qIndex];
                    w = i.getWord();
                    flipBitLiteral = ConciseSetUtils.getLiteralFromOneSeqFlipBit(w);
                    if (flipBitLiteral != -1) {
                        i.word = flipBitLiteral;
                        maxChangedIndex = qIndex++;
                        continue;
                    }
                    if (i.hasNext()) {
                        i.word = i.next();
                        maxChangedIndex = qIndex++;
                        continue;
                    }
                    ImmutableConciseSet.removeElement(theQ, qIndex, qSize);
                    --qSize;
                    wordsWalkedAtSequenceEnd = Math.min(i.wordsWalked, wordsWalkedAtSequenceEnd);
                }
                flipBitLiteral = ConciseSetUtils.getLiteralFromOneSeqFlipBit(word);
                if (flipBitLiteral != -1) {
                    itr.word = flipBitLiteral;
                    maxChangedIndex = Math.max(maxChangedIndex, 0);
                } else if (itr.hasNext()) {
                    itr.word = itr.next();
                    maxChangedIndex = Math.max(maxChangedIndex, 0);
                } else {
                    ImmutableConciseSet.removeElement(theQ, 0, qSize);
                    --qSize;
                    wordsWalkedAtSequenceEnd = Math.min(itr.wordsWalked, wordsWalkedAtSequenceEnd);
                }
            }
            if (maxChangedIndex < 0) continue;
            ImmutableConciseSet.partialSort(theQ, maxChangedIndex, qSize, INTERSECTION_COMPARATOR);
        }
        if (currIndex < wordsWalkedAtSequenceEnd) {
            ImmutableConciseSet.addAndCompact(retVal, 0x40000000 | wordsWalkedAtSequenceEnd - currIndex - 1);
        }
        if (retVal.isEmpty()) {
            return new ImmutableConciseSet();
        }
        return new ImmutableConciseSet(IntBuffer.wrap(retVal.toArray()));
    }

    private static void partialSort(WordIterator[] a, int maxChangedIndex, int size, Comparator<WordIterator> comp) {
        for (int i = maxChangedIndex; i >= 0; --i) {
            WordIterator it2;
            WordIterator it = a[i];
            for (int j = i + 1; j < size && comp.compare(it, it2 = a[j]) > 0; ++j) {
                a[j - 1] = it2;
                a[j] = it;
            }
        }
    }

    private static void removeElement(WordIterator[] q, int qIndex, int qSize) {
        System.arraycopy(q, qIndex + 1, q, qIndex, qSize - qIndex - 1);
    }

    public static ImmutableConciseSet doComplement(ImmutableConciseSet set) {
        if (set == null || set.isEmpty()) {
            return new ImmutableConciseSet();
        }
        IntList retVal = new IntList();
        WordIterator iter = set.newWordIterator();
        while (iter.hasNext()) {
            int word = iter.next();
            if (ConciseSetUtils.isLiteral(word)) {
                retVal.add(Integer.MIN_VALUE | ~word);
                continue;
            }
            retVal.add(0x40000000 ^ word);
        }
        int lastWord = retVal.get(retVal.length() - 1);
        if (ConciseSetUtils.isLiteral(lastWord)) {
            lastWord = ConciseSetUtils.clearBitsAfterInLastWord(lastWord, ConciseSetUtils.maxLiteralLengthModulus(set.getLast()));
        }
        retVal.set(retVal.length() - 1, lastWord);
        ImmutableConciseSet.trimZeros(retVal);
        if (retVal.isEmpty()) {
            return new ImmutableConciseSet();
        }
        return new ImmutableConciseSet(IntBuffer.wrap(retVal.toArray()));
    }

    private static void trimZeros(IntList set) {
        int last = set.length() - 1;
        do {
            int w;
            if ((w = set.get(last)) == Integer.MIN_VALUE) {
                set.set(last, 0);
                --last;
                continue;
            }
            if (ConciseSetUtils.isZeroSequence(w)) {
                if (ConciseSetUtils.isSequenceWithNoBits(w)) {
                    set.set(last, 0);
                    --last;
                    continue;
                }
                set.set(last, ConciseSetUtils.getLiteral(w, false));
                return;
            }
            return;
        } while (!set.isEmpty() && last != -1);
    }

    public ImmutableConciseSet() {
        this.words = null;
        this.lastWordIndex = -1;
        this.size = 0;
    }

    public ImmutableConciseSet(ByteBuffer byteBuffer) {
        this.words = byteBuffer.asIntBuffer();
        this.lastWordIndex = this.words.capacity() - 1;
        this.size = this.calcSize();
    }

    public ImmutableConciseSet(IntBuffer buffer) {
        this.words = buffer;
        this.lastWordIndex = this.words == null || buffer.capacity() == 0 ? -1 : this.words.capacity() - 1;
        this.size = this.calcSize();
    }

    public byte[] toBytes() {
        if (this.words == null) {
            return new byte[0];
        }
        ByteBuffer buf = ByteBuffer.allocate(this.words.capacity() * 4);
        buf.asIntBuffer().put(this.words.asReadOnlyBuffer());
        return buf.array();
    }

    public int getLastWordIndex() {
        return this.lastWordIndex;
    }

    private int calcSize() {
        int retVal = 0;
        for (int i = 0; i <= this.lastWordIndex; ++i) {
            int w = this.words.get(i);
            if (ConciseSetUtils.isLiteral(w)) {
                retVal += ConciseSetUtils.getLiteralBitCount(w);
                continue;
            }
            if (ConciseSetUtils.isZeroSequence(w)) {
                if (ConciseSetUtils.isSequenceWithNoBits(w)) continue;
                ++retVal;
                continue;
            }
            retVal += ConciseSetUtils.maxLiteralLengthMultiplication(ConciseSetUtils.getSequenceCount(w) + 1);
            if (ConciseSetUtils.isSequenceWithNoBits(w)) continue;
            --retVal;
        }
        return retVal;
    }

    public int size() {
        return this.size;
    }

    public int getLast() {
        if (this.isEmpty()) {
            return -1;
        }
        int last = 0;
        for (int i = 0; i <= this.lastWordIndex; ++i) {
            int w = this.words.get(i);
            if (ConciseSetUtils.isLiteral(w)) {
                last += 31;
                continue;
            }
            last += ConciseSetUtils.maxLiteralLengthMultiplication(ConciseSetUtils.getSequenceCount(w) + 1);
        }
        int w = this.words.get(this.lastWordIndex);
        last = ConciseSetUtils.isLiteral(w) ? (last -= Integer.numberOfLeadingZeros(ConciseSetUtils.getLiteralBits(w))) : --last;
        return last;
    }

    public boolean contains(int integer) {
        if (this.isEmpty()) {
            return false;
        }
        IntSet.IntIterator intIterator = this.iterator();
        intIterator.skipAllBefore(integer);
        return intIterator.hasNext() && intIterator.next() == integer;
    }

    public int get(int i) {
        if (i < 0) {
            throw new IndexOutOfBoundsException();
        }
        int firstSetBitInWord = 0;
        int position = i;
        int setBitsInCurrentWord = 0;
        for (int j = 0; j <= this.lastWordIndex; ++j) {
            int w = this.words.get(j);
            if (ConciseSetUtils.isLiteral(w)) {
                setBitsInCurrentWord = ConciseSetUtils.getLiteralBitCount(w);
                if (position < setBitsInCurrentWord) {
                    int currSetBitInWord = -1;
                    while (position >= 0) {
                        currSetBitInWord = Integer.numberOfTrailingZeros(w & -1 << currSetBitInWord + 1);
                        --position;
                    }
                    return firstSetBitInWord + currSetBitInWord;
                }
                firstSetBitInWord += 31;
            } else {
                int sequenceLength = ConciseSetUtils.maxLiteralLengthMultiplication(ConciseSetUtils.getSequenceCount(w) + 1);
                if (ConciseSetUtils.isOneSequence(w)) {
                    if (ConciseSetUtils.isSequenceWithNoBits(w)) {
                        setBitsInCurrentWord = sequenceLength;
                        if (position < setBitsInCurrentWord) {
                            return firstSetBitInWord + position;
                        }
                    } else {
                        setBitsInCurrentWord = sequenceLength - 1;
                        if (position < setBitsInCurrentWord) {
                            return firstSetBitInWord + position + (position < ConciseSetUtils.getFlippedBit(w) ? 0 : 1);
                        }
                    }
                } else if (ConciseSetUtils.isSequenceWithNoBits(w)) {
                    setBitsInCurrentWord = 0;
                } else {
                    setBitsInCurrentWord = 1;
                    if (position == 0) {
                        return firstSetBitInWord + ConciseSetUtils.getFlippedBit(w);
                    }
                }
                firstSetBitInWord += sequenceLength;
            }
            position -= setBitsInCurrentWord;
        }
        throw new IndexOutOfBoundsException(Integer.toString(i));
    }

    public int compareTo(ImmutableConciseSet other) {
        return this.words.asReadOnlyBuffer().compareTo(other.words.asReadOnlyBuffer());
    }

    private boolean isEmpty() {
        return this.words == null || this.words.limit() == 0;
    }

    public String toString() {
        IntSet.IntIterator itr = this.iterator();
        if (!itr.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            sb.append(itr.next());
            if (!itr.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    public IntSet.IntIterator iterator() {
        if (this.isEmpty()) {
            return EmptyIntIterator.instance();
        }
        return new BitIterator(this);
    }

    public WordIterator newWordIterator() {
        return new WordIterator();
    }

    public class WordIterator
    implements IntIterator,
    Cloneable {
        private int startIndex = -1;
        private int wordsWalked = 0;
        private int currWord;
        private int nextWord;
        private int currRow = -1;
        int word;
        private boolean hasNextWord = false;

        WordIterator() {
        }

        public void advanceTo(int endCount) {
            while (this.hasNext() && this.wordsWalked < endCount) {
                this.next();
            }
            if (this.wordsWalked <= endCount) {
                return;
            }
            this.nextWord = this.currWord & 0xC1000000 | this.wordsWalked - endCount - 1;
            this.startIndex = endCount;
            this.hasNextWord = true;
        }

        public boolean hasNext() {
            if (ImmutableConciseSet.this.isEmpty()) {
                return false;
            }
            if (this.hasNextWord) {
                return true;
            }
            return this.currRow < ImmutableConciseSet.this.words.capacity() - 1;
        }

        public int next() {
            if (this.hasNextWord) {
                this.currWord = this.nextWord;
                this.hasNextWord = false;
                return this.currWord;
            }
            this.currWord = ImmutableConciseSet.this.words.get(++this.currRow);
            if (ConciseSetUtils.isLiteral(this.currWord)) {
                this.startIndex = this.wordsWalked++;
            } else {
                this.startIndex = this.wordsWalked;
                this.wordsWalked += ConciseSetUtils.getSequenceNumWords(this.currWord);
            }
            return this.currWord;
        }

        int getWord() {
            return this.word;
        }

        public WordIterator clone() {
            try {
                return (WordIterator)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

