/*
 * Decompiled with CFR 0.152.
 */
package io.druid.extendedset.intset;

import io.druid.extendedset.intset.ConciseSetUtils;
import io.druid.extendedset.intset.ImmutableConciseSet;
import io.druid.extendedset.intset.IntSet;
import java.util.NoSuchElementException;

public final class BitIterator
implements IntSet.IntIterator {
    private final ImmutableConciseSet immutableConciseSet;
    private boolean literalAndZeroFill;
    private int nextIndex = 0;
    private int nextOffset = 0;
    private int next = -1;
    private final int[] literalAndZeroFillBuffer = new int[31];
    private int literalAndZeroFillLen = 0;
    private int literalAndZeroFillCurrent = 0;
    private int oneFillFirstInt = 1;
    private int oneFillLastInt = -1;
    private int oneFillCurrent = 0;
    private int oneFillException = -1;

    BitIterator(ImmutableConciseSet immutableConciseSet) {
        this.immutableConciseSet = immutableConciseSet;
        this.nextWord();
        this.next = this.advance();
    }

    private BitIterator(ImmutableConciseSet immutableConciseSet, boolean literalAndZeroFill, int nextIndex, int nextOffset, int next, int literalAndZeroFillLen, int literalAndZeroFillCurrent, int oneFillFirstInt, int oneFillLastInt, int oneFillCurrent, int oneFillException) {
        this.immutableConciseSet = immutableConciseSet;
        this.literalAndZeroFill = literalAndZeroFill;
        this.nextIndex = nextIndex;
        this.nextOffset = nextOffset;
        this.next = next;
        this.literalAndZeroFillLen = literalAndZeroFillLen;
        this.literalAndZeroFillCurrent = literalAndZeroFillCurrent;
        this.oneFillFirstInt = oneFillFirstInt;
        this.oneFillLastInt = oneFillLastInt;
        this.oneFillCurrent = oneFillCurrent;
        this.oneFillException = oneFillException;
    }

    @Override
    public boolean hasNext() {
        return this.next >= 0;
    }

    private int advance() {
        int wordExpanderNext;
        while ((wordExpanderNext = this.wordExpanderAdvance()) < 0) {
            if (this.nextIndex > this.immutableConciseSet.lastWordIndex) {
                return -1;
            }
            this.nextWord();
        }
        return wordExpanderNext;
    }

    @Override
    public int next() {
        int prev = this.next;
        if (prev >= 0) {
            this.next = this.advance();
            return prev;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void skipAllBefore(int element) {
        if (element <= this.next) {
            return;
        }
        while (true) {
            this.wordExpanderSkipAllBefore(element);
            int wordExpanderNext = this.wordExpanderAdvance();
            if (wordExpanderNext >= 0) {
                this.next = wordExpanderNext;
                return;
            }
            if (this.nextIndex > this.immutableConciseSet.lastWordIndex) {
                this.next = -1;
                return;
            }
            this.nextWord();
        }
    }

    @Override
    public IntSet.IntIterator clone() {
        BitIterator clone = new BitIterator(this.immutableConciseSet, this.literalAndZeroFill, this.nextIndex, this.nextOffset, this.next, this.literalAndZeroFillLen, this.literalAndZeroFillCurrent, this.oneFillFirstInt, this.oneFillLastInt, this.oneFillCurrent, this.oneFillException);
        System.arraycopy(this.literalAndZeroFillBuffer, 0, clone.literalAndZeroFillBuffer, 0, this.literalAndZeroFillBuffer.length);
        return clone;
    }

    private void nextWord() {
        int word = this.immutableConciseSet.words.get(this.nextIndex++);
        this.literalAndZeroFill = this.wordExpanderReset(this.nextOffset, word);
        this.nextOffset = ConciseSetUtils.isLiteral(word) ? (this.nextOffset += 31) : (this.nextOffset += ConciseSetUtils.maxLiteralLengthMultiplication(ConciseSetUtils.getSequenceCount(word) + 1));
    }

    private int wordExpanderAdvance() {
        return this.literalAndZeroFill ? this.literalAndZeroFillAdvance() : this.oneFillAdvance();
    }

    private void wordExpanderSkipAllBefore(int i) {
        if (this.literalAndZeroFill) {
            this.literalAndZeroFillSkipAllBefore(i);
        } else {
            this.oneFillSkipAllBefore(i);
        }
    }

    private boolean wordExpanderReset(int offset, int word) {
        if (ConciseSetUtils.isLiteral(word)) {
            this.literalAndZeroFillResetLiteral(offset, word);
            return true;
        }
        if (ConciseSetUtils.isZeroSequence(word)) {
            this.literalAndZeroFillResetZeroSequence(offset, word);
            return true;
        }
        this.oneFillReset(offset, word);
        return false;
    }

    private int literalAndZeroFillAdvance() {
        if (this.literalAndZeroFillCurrent < this.literalAndZeroFillLen) {
            return this.literalAndZeroFillBuffer[this.literalAndZeroFillCurrent++];
        }
        return -1;
    }

    private void literalAndZeroFillSkipAllBefore(int i) {
        while (this.literalAndZeroFillCurrent < this.literalAndZeroFillLen && this.literalAndZeroFillBuffer[this.literalAndZeroFillCurrent] < i) {
            ++this.literalAndZeroFillCurrent;
        }
    }

    private void literalAndZeroFillResetZeroSequence(int offset, int word) {
        if (ConciseSetUtils.isSequenceWithNoBits(word)) {
            this.literalAndZeroFillLen = 0;
            this.literalAndZeroFillCurrent = 0;
        } else {
            this.literalAndZeroFillLen = 1;
            this.literalAndZeroFillBuffer[0] = offset + ((0x3FFFFFFF & word) >>> 25) - 1;
            this.literalAndZeroFillCurrent = 0;
        }
    }

    private void literalAndZeroFillResetLiteral(int offset, int word) {
        this.literalAndZeroFillLen = 0;
        for (int i = 0; i < 31; ++i) {
            if ((word & 1 << i) == 0) continue;
            this.literalAndZeroFillBuffer[this.literalAndZeroFillLen++] = offset + i;
        }
        this.literalAndZeroFillCurrent = 0;
    }

    private int oneFillAdvance() {
        int oneFillCurrent = this.oneFillCurrent;
        if (oneFillCurrent < this.oneFillLastInt) {
            return this.oneFillDoAdvance(oneFillCurrent);
        }
        return -1;
    }

    private int oneFillDoAdvance(int oneFillCurrent) {
        if (++oneFillCurrent == this.oneFillException) {
            ++oneFillCurrent;
        }
        this.oneFillCurrent = oneFillCurrent;
        return oneFillCurrent;
    }

    private void oneFillSkipAllBefore(int i) {
        if (i <= this.oneFillCurrent) {
            return;
        }
        this.oneFillCurrent = i - 1;
    }

    private void oneFillReset(int offset, int word) {
        if (!ConciseSetUtils.isOneSequence(word)) {
            throw new RuntimeException("NOT a sequence of ones!");
        }
        this.oneFillFirstInt = offset;
        this.oneFillLastInt = offset + ConciseSetUtils.maxLiteralLengthMultiplication(ConciseSetUtils.getSequenceCount(word) + 1) - 1;
        this.oneFillException = offset + ((0x3FFFFFFF & word) >>> 25) - 1;
        if (this.oneFillException == this.oneFillFirstInt) {
            ++this.oneFillFirstInt;
        }
        if (this.oneFillException == this.oneFillLastInt) {
            --this.oneFillLastInt;
        }
        this.oneFillCurrent = this.oneFillFirstInt - 1;
    }
}

