/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.quantiles;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.DoublesUnion;
import io.druid.java.util.common.IAE;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.datasketches.quantiles.DoublesSketchBuildAggregator;
import io.druid.query.aggregation.datasketches.quantiles.DoublesSketchBuildBufferAggregator;
import io.druid.query.aggregation.datasketches.quantiles.DoublesSketchMergeAggregator;
import io.druid.query.aggregation.datasketches.quantiles.DoublesSketchMergeAggregatorFactory;
import io.druid.query.aggregation.datasketches.quantiles.DoublesSketchMergeBufferAggregator;
import io.druid.query.aggregation.datasketches.quantiles.DoublesSketchNoOpAggregator;
import io.druid.query.aggregation.datasketches.quantiles.DoublesSketchNoOpBufferAggregator;
import io.druid.query.aggregation.datasketches.quantiles.DoublesSketchOperations;
import io.druid.query.cache.CacheKeyBuilder;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.NilColumnValueSelector;
import io.druid.segment.column.ValueType;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class DoublesSketchAggregatorFactory
extends AggregatorFactory {
    private static final int DEFAULT_K = 128;
    private static final long MAX_STREAM_LENGTH = 1000000000L;
    private final String name;
    private final String fieldName;
    private final int k;
    private final byte cacheTypeId;
    public static final Comparator<DoublesSketch> COMPARATOR = new Comparator<DoublesSketch>(){

        @Override
        public int compare(DoublesSketch a, DoublesSketch b) {
            return Long.compare(a.getN(), b.getN());
        }
    };

    @JsonCreator
    public DoublesSketchAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="k") Integer k) {
        this(name, fieldName, k, 27);
    }

    DoublesSketchAggregatorFactory(String name, String fieldName, Integer k, byte cacheTypeId) {
        if (name == null) {
            throw new IAE("Must have a valid, non-null aggregator name", new Object[0]);
        }
        this.name = name;
        if (fieldName == null) {
            throw new IAE("Parameter fieldName must be specified", new Object[0]);
        }
        this.fieldName = fieldName;
        this.k = k == null ? 128 : k;
        Util.checkIfPowerOf2((int)this.k, (String)"k");
        this.cacheTypeId = cacheTypeId;
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        if (metricFactory.getColumnCapabilities(this.fieldName) != null && ValueType.isNumeric((ValueType)metricFactory.getColumnCapabilities(this.fieldName).getType())) {
            ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
            if (selector instanceof NilColumnValueSelector) {
                return new DoublesSketchNoOpAggregator();
            }
            return new DoublesSketchBuildAggregator((ColumnValueSelector<Double>)selector, this.k);
        }
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (selector instanceof NilColumnValueSelector) {
            return new DoublesSketchNoOpAggregator();
        }
        return new DoublesSketchMergeAggregator((ColumnValueSelector<DoublesSketch>)selector, this.k);
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        if (metricFactory.getColumnCapabilities(this.fieldName) != null && ValueType.isNumeric((ValueType)metricFactory.getColumnCapabilities(this.fieldName).getType())) {
            ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
            if (selector instanceof NilColumnValueSelector) {
                return new DoublesSketchNoOpBufferAggregator();
            }
            return new DoublesSketchBuildBufferAggregator((ColumnValueSelector<Double>)selector, this.k, this.getMaxIntermediateSize());
        }
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (selector instanceof NilColumnValueSelector) {
            return new DoublesSketchNoOpBufferAggregator();
        }
        return new DoublesSketchMergeBufferAggregator((ColumnValueSelector<DoublesSketch>)selector, this.k, this.getMaxIntermediateSize());
    }

    public Object deserialize(Object object) {
        return DoublesSketchOperations.deserialize(object);
    }

    public Comparator<DoublesSketch> getComparator() {
        return COMPARATOR;
    }

    public Object combine(Object lhs, Object rhs) {
        DoublesUnion union = DoublesUnion.builder().setMaxK(this.k).build();
        union.update((DoublesSketch)lhs);
        union.update((DoublesSketch)rhs);
        return union.getResultAndReset();
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public int getK() {
        return this.k;
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public int getMaxIntermediateSize() {
        return DoublesSketch.getUpdatableStorageBytes((int)this.k, (long)1000000000L);
    }

    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new DoublesSketchAggregatorFactory(this.fieldName, this.fieldName, this.k));
    }

    public AggregatorFactory getCombiningFactory() {
        return new DoublesSketchMergeAggregatorFactory(this.name, this.k);
    }

    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && other instanceof DoublesSketchAggregatorFactory) {
            return new DoublesSketchMergeAggregatorFactory(this.name, Math.max(this.k, ((DoublesSketchAggregatorFactory)other).k));
        }
        throw new AggregatorFactoryNotMergeableException((AggregatorFactory)this, other);
    }

    public Object finalizeComputation(Object object) {
        return ((DoublesSketch)object).getN();
    }

    public String getTypeName() {
        return "quantilesDoublesSketch";
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(this.cacheTypeId).appendString(this.name).appendString(this.fieldName).appendInt(this.k).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !((Object)((Object)this)).getClass().equals(o.getClass())) {
            return false;
        }
        DoublesSketchAggregatorFactory that = (DoublesSketchAggregatorFactory)((Object)o);
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.fieldName.equals(that.fieldName)) {
            return false;
        }
        return this.k == that.k;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.k);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{name=" + this.name + ", fieldName=" + this.fieldName + ", k=" + this.k + "}";
    }
}

