/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.quantiles;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.ColumnValueSelector;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;

public class DoublesSketchBuildBufferAggregator
implements BufferAggregator {
    private final ColumnValueSelector<Double> selector;
    private final int size;
    private final int maxIntermediateSize;
    private final IdentityHashMap<ByteBuffer, WritableMemory> memCache = new IdentityHashMap();
    private final IdentityHashMap<ByteBuffer, Int2ObjectMap<UpdateDoublesSketch>> sketches = new IdentityHashMap();

    public DoublesSketchBuildBufferAggregator(ColumnValueSelector<Double> valueSelector, int size, int maxIntermediateSize) {
        this.selector = valueSelector;
        this.size = size;
        this.maxIntermediateSize = maxIntermediateSize;
    }

    public synchronized void init(ByteBuffer buffer, int position) {
        WritableMemory mem = this.getMemory(buffer);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        UpdateDoublesSketch sketch = UpdateDoublesSketch.builder().setK(this.size).build(region);
        this.putSketch(buffer, position, sketch);
    }

    public synchronized void aggregate(ByteBuffer buffer, int position) {
        UpdateDoublesSketch sketch = (UpdateDoublesSketch)this.sketches.get(buffer).get(position);
        sketch.update(this.selector.getDouble());
    }

    public synchronized Object get(ByteBuffer buffer, int position) {
        return this.sketches.get(buffer).get(position);
    }

    public float getFloat(ByteBuffer buffer, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buffer, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public synchronized void close() {
        this.sketches.clear();
        this.memCache.clear();
    }

    public synchronized void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        WritableMemory oldRegion;
        UpdateDoublesSketch sketch = (UpdateDoublesSketch)this.sketches.get(oldBuffer).get(oldPosition);
        if (sketch.isSameResource((Memory)(oldRegion = this.getMemory(oldBuffer).writableRegion((long)oldPosition, (long)this.maxIntermediateSize)))) {
            WritableMemory newRegion = this.getMemory(newBuffer).writableRegion((long)newPosition, (long)this.maxIntermediateSize);
            sketch = UpdateDoublesSketch.wrap((WritableMemory)newRegion);
        }
        this.putSketch(newBuffer, newPosition, sketch);
        Int2ObjectMap<UpdateDoublesSketch> map = this.sketches.get(oldBuffer);
        map.remove(oldPosition);
        if (map.isEmpty()) {
            this.sketches.remove(oldBuffer);
            this.memCache.remove(oldBuffer);
        }
    }

    private WritableMemory getMemory(ByteBuffer buffer) {
        return this.memCache.computeIfAbsent(buffer, buf -> WritableMemory.wrap((ByteBuffer)buf));
    }

    private void putSketch(ByteBuffer buffer, int position, UpdateDoublesSketch sketch) {
        Int2ObjectMap map = this.sketches.computeIfAbsent(buffer, buf -> new Int2ObjectOpenHashMap());
        map.put(position, (Object)sketch);
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
    }
}

