/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.quantiles;

import com.google.common.base.Supplier;
import com.yahoo.memory.Memory;
import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import io.druid.data.input.InputRow;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import io.druid.query.aggregation.datasketches.quantiles.DoublesSketchObjectStrategy;
import io.druid.query.aggregation.datasketches.quantiles.DoublesSketchOperations;
import io.druid.segment.GenericColumnSerializer;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.ObjectStrategy;
import io.druid.segment.serde.ComplexColumnPartSupplier;
import io.druid.segment.serde.ComplexMetricExtractor;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import java.nio.ByteBuffer;

public class DoublesSketchComplexMetricSerde
extends ComplexMetricSerde {
    private static final DoublesSketchObjectStrategy strategy = new DoublesSketchObjectStrategy();

    public String getTypeName() {
        return "quantilesDoublesSketch";
    }

    public ObjectStrategy<DoublesSketch> getObjectStrategy() {
        return strategy;
    }

    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){
            private static final int MIN_K = 2;

            public Class<?> extractedClass() {
                return DoublesSketch.class;
            }

            public Object extractValue(InputRow inputRow, String metricName) {
                Object object = inputRow.getRaw(metricName);
                if (object instanceof String) {
                    String objectString = (String)object;
                    if (Character.isDigit(objectString.charAt(0))) {
                        try {
                            Double doubleValue = Double.parseDouble(objectString);
                            UpdateDoublesSketch sketch = DoublesSketch.builder().setK(2).build();
                            sketch.update(doubleValue.doubleValue());
                            return sketch;
                        }
                        catch (NumberFormatException e) {
                            throw new IAE("Expected a string with a number, received value " + objectString, new Object[0]);
                        }
                    }
                } else if (object instanceof Number) {
                    UpdateDoublesSketch sketch = DoublesSketch.builder().setK(2).build();
                    sketch.update(((Number)object).doubleValue());
                    return sketch;
                }
                if (object == null || object instanceof DoublesSketch || object instanceof Memory) {
                    return object;
                }
                return DoublesSketchOperations.deserialize(object);
            }
        };
    }

    public void deserializeColumn(ByteBuffer buffer, ColumnBuilder builder) {
        GenericIndexed column = GenericIndexed.read((ByteBuffer)buffer, (ObjectStrategy)strategy, (SmooshedFileMapper)builder.getFileMapper());
        builder.setComplexColumn((Supplier)new ComplexColumnPartSupplier(this.getTypeName(), column));
    }

    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column) {
        return LargeColumnSupportedComplexColumnSerializer.create((SegmentWriteOutMedium)segmentWriteOutMedium, (String)column, this.getObjectStrategy());
    }
}

